import {
  Button,
  Card,
  DisplayText,
  Heading,
  Icon,
  Subheading,
} from '@shopify/polaris';
import {
  CollectionsMajor,
  ClockMajor,
  DataVisualizationMajor,
  EditMajor,
  FolderDownMajor,
  StarFilledMinor,
  ThumbsUpMajor,
} from '@shopify/polaris-icons';

import '../global/plans.scss';
import App from '../../App';



function Plans(props) {
  //console.log(JSON.stringify(props));
  const plans = props.plans;
  const boxHeight = props.boxHeight
  //const planUrl = props.planUrl;
  //const storeUrl = props.StoreUrl;

  return (
    <div className="plans-container">
      <div className="iec-flex-container">
        {Object.keys(plans).map((plan,i) =>  (   
          <div className="iec-flex-item" key={i}>
            <Card>
              <Subheading element="h2" style={{fontSize: '38px'}}>{plans[plan].charge_plan}<span>{plans[plan].display_text}</span></Subheading>
              <Features
                features={plans[plan].features}
                boxHeight={boxHeight}
              />
              <div className="plan-selection">
                {plans[plan].selected == true? <Button primary disabled size="medium">Selected</Button>:<Button primary size="medium" onClick={() => {changePlan(props.planUrl,props.storeUrl,plan,props.token)}}>Go {plan}</Button> }
              </div>
            </Card>
          </div>
        ))}
      </div>
    </div>
  );
}

function Features(props){
  const features = props.features;
  const boxHeight = props.boxHeight;
  return (
    <div className={'plan-item'}>
      <strong>Limits</strong>
      <ul className={'plan-feature-list'} style={{ height: boxHeight + 'px'}}>
          {features.map((feature,i) =>  (   
            <li key={i} style={{ textDecorationLine: feature.struck? 'line-through': ''}} className={ feature.struck? 'line-through': ''}>
              {renderIcon(feature.icon)}
              {feature.text}
              <span className='plan-item-value'>{feature.value}</span>
            </li>
          ))}
      </ul>
    </div>
  );
}
function changePlan(planUrl,storeUrl,plan,token){
  let url = planUrl+'?shop='+storeUrl+'&plan='+plan+'&token='+token;
  window.top.location.href = url;
}
function renderIcon(icon) {
  switch(icon) {
    case 'Collections':
      return <Icon source={CollectionsMajor} color="base" />;
      case 'Data Visualization':
      return <Icon source={DataVisualizationMajor} color="base" />;
      case 'Clock':
        return <Icon source={ClockMajor} color="base" />;
      case 'Edit':
        return <Icon source={EditMajor} color="base" />;
      case 'Star Filled':
        return <Icon source={StarFilledMinor} color="base" />;
      case 'Thumbs Up':
        return <Icon source={ThumbsUpMajor} color="base" />;
        case 'Folder Down':
        return <Icon source={FolderDownMajor} color="base" />;                                                       
      default:
      return '';
  }
}

export default Plans;
