import {
    Button,
    Card,
    Checkbox,
    Filters,
    Icon,
    Popover,
    TextContainer,
    TextField,
  } from '@shopify/polaris';
  
//import '../global/plans.scss';
import App from '../../App';
import {
    ProductsMajor,
} from '@shopify/polaris-icons';
  
  
function IndexTableCustomHeadings(props) {
  //console.log(props.attributes);

  const onChange = (value,productId,index) => {
    console.log('boost onChange: '+value+' pid: '+productId+' i:'+index);
    props.change(value,productId,index);
  }
  const onSave = (productId,index) => {
    console.log('onSave pid: '+productId+' i:'+index);
    props.save(productId,index);
  }
  const loadMore = () => {
    console.log('loadMore');
    props.loadMore();
  }
  const editProductRowsActivator = (
    <Button onClick={()=>{console.log('click')}} disclosure>
      Edit Product Rows
    </Button>
  );
  let randomTotal = [];
  let productCountTotalItems = ((props.showProductIndex+1)*props.showProductCount)
  return (
    <Card>
      <Card.Section>
        <div class="product-index-table">
            <div class="Polaris-IndexTable">
                <div class="Polaris-IndexTable__StickyTable" role="presentation">
                    <div>
                        <div></div>
                        <div>
                            <div class="Polaris-IndexTable__StickyTableHeader">
                                <div class="Polaris-IndexTable__StickyTableColumnHeader">
                                    <div class="Polaris-IndexTable__TableHeading" data-index-table-sticky-heading="true">
                                        <div class="Polaris-Stack Polaris-Stack--spacingNone Polaris-Stack--alignmentCenter Polaris-Stack--noWrap">
                                            <div class="Polaris-Stack__Item">
                                                <div class="Polaris-IndexTable__FirstStickyHeaderElement">

                                                </div>
                                            </div>
                                            <div class="Polaris-Stack__Item">
                                                <div class="Polaris-IndexTable--stickyTableHeadingSecondScrolling">Product</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="Polaris-IndexTable__StickyTableHeadings">
                                    <div class="Polaris-IndexTable__TableHeading Polaris-IndexTable__StickyTableHeading--second" data-index-table-sticky-heading="true">Product</div>
                                    <div class="Polaris-IndexTable__TableHeading" data-index-table-sticky-heading="true"><span className={"table-heading-dot "+((parseInt(props.boost) > 0)? 'active':'inactive')}></span>Boost</div>
                                    {
                                        Object.keys(props.attributes).map(function(keyName, keyIndex) {
                                            return <div className={"Polaris-IndexTable__TableHeading display-"+(props.attributes[keyName].display)} data-index-table-sticky-heading="true"><span className={"table-heading-dot "+((props.attributes[keyName].in_use == true)? 'active':'inactive')}></span>{props.attributes[keyName].label}</div>
                                        })
                                    }
                                    <div class="Polaris-IndexTable__TableHeading" data-index-table-sticky-heading="true">Totals</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="Polaris-IndexTable-ScrollContainer">
                    <table class="Polaris-IndexTable__Table Polaris-IndexTable--tableStickyLast Polaris-IndexTable--tableStickyScrolling">
                        <thead>
                            <tr>
                                <th class="Polaris-IndexTable__TableHeading Polaris-IndexTable__TableHeading--second" data-index-table-heading="true">Product</th>
                                <th class="Polaris-IndexTable__TableHeading" data-index-table-heading="true"><span className={"table-heading-dot "+((parseInt(props.boost) > 0)? 'active':'inactive')}></span>Boost</th>
                                {
                                        Object.keys(props.attributes).map(function(keyName, keyIndex) {
                                            //(props.attributes[keyName].in_use && props.attributes[keyName].display) ? '':'';
                                            return <th className={"Polaris-IndexTable__TableHeading display-"+(props.attributes[keyName].display)} data-index-table-heading="true">{(keyName == 'boost' ? <span className={"table-heading-dot "+((props.attributes[keyName].in_use == true)? 'active':'inactive')}></span>:'')}{props.attributes[keyName].label}</th>
                                        })
                                }
                                <th class="Polaris-IndexTable__TableHeading Polaris-IndexTable__TableHeading--last" data-index-table-heading="true">Totals</th>
                            </tr>
                        </thead>
                        <tbody>
                        {(props.products.length == 0) ? <tr><td colspan={"100%"}><div className={"products-empty"}><Icon source={ProductsMajor} color="base" /><TextContainer>No Products Found</TextContainer><p>Once you add some products to this collection in Shopify, they will display here.</p></div></td></tr>:''}
                        {props.products.map(function(product, i){
                            randomTotal[i] = 0;
                            if(
                                i < productCountTotalItems
                            ) {
                                return <tr class="Polaris-IndexTable__TableRow">
                                        <td class="Polaris-IndexTable__TableCell">
                                            <div class="products-product-data">
                                                <div class="image">
                                                    <img src={product.image} alt={product.title} />
                                                </div>
                                                <div class="products-product-info">
                                                    <strong>{product.title}</strong>
                                                    {(product.price_varies == "1"? <span>${product.price_min}-${product.price_max}</span>:<span>${product.price_min}</span>)}
                                                    <span class="sep">/</span>
                                                    <span>{product.inventory_quantity} Available</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="Polaris-IndexTable__TableCell">
                                            <div class="products-product-boost">
                                                <TextField
                                                    value={product.boost}
                                                    type="number"
                                                    onChange={(value) => {onChange(value,product.product_id,i)}}
                                                    label="Boost"
                                                    autoComplete="off"
                                                    labelHidden
                                                />
                                                <Button
                                                  disabled={(product.saveable == true? false:true)}
                                                  onClick={()=>{ onSave(product.product_id,i)}}
                                                  primary
                                                >Save</Button>
                                            </div>
                                        </td>
                                        {
                                        
                                        Object.keys(props.attributes).map(function(keyName, keyIndex) {
                                            let attrRandomValue = randomDisplayValue(props.attributes[keyName].weight);
                                            //console.log('attrRandomValue '+attrRandomValue);
                                            randomTotal[i] = randomTotal[i] + attrRandomValue;
                                            //(props.attributes[keyName].in_use && props.attributes[keyName].display) ? '':'';
                                            return  <td className={"Polaris-IndexTable__TableCell display-"+(props.attributes[keyName].display)}>
                                                        <div className={"products-product-"+keyName}>
                                                            {/*<strong>{keyName}?</strong>*/}
                                                            <strong>{product['values'][keyName]}</strong>
                                                            <span>{props.attributes[keyName].weight}</span>
                                                        </div>
                                                    </td>
                                            //<th className={"Polaris-IndexTable__TableHeading display-"+(props.attributes[keyName].display)} data-index-table-heading="true">{props.attributes[keyName].label}</th>
                                        })
                                        }

                                        <td class="Polaris-IndexTable__TableCell">
                                            <div class="products-product-totals">
                                                <strong>{product['values']['total']}</strong>
                                            </div>
                                        </td>
                                    </tr>
                                    }
                            
                                }
                            )
                        }
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="Polaris-IndexTable__ScrollBarContainer">
                <div class="Polaris-IndexTable__ScrollBar">
                    <div class="Polaris-IndexTable__ScrollBarContent"></div>
                </div>
            </div>
        </div>
        </Card.Section>
        <div class="products-footer">
            <Card.Section>
                {(props.products.length <= productCountTotalItems)?
                <p>Showing {props.products.length} of {props.products.length} products</p>
                :
                <p>Showing {productCountTotalItems} of {props.products.length} products <Button plain onClick={()=>{loadMore()}}>Load Next {((props.products.length - (props.showProductCount)) < props.showProductCount)? (props.products.length - props.showProductCount):props.showProductCount}</Button></p>
                }                
            </Card.Section>
        </div>
    </Card>
);
}
function randomDisplayValue(weight){
    let value =  Math.floor(Math.random() * weight) + 1;
    //console.log('randomDisplayValue '+weight+' / '+value);
    return value;
}

export default IndexTableCustomHeadings;
  