import {
    Badge,
    Button,
    Label,
    Select,
    TextField,
    TextStyle,
  } from '@shopify/polaris';  
  import '../global/configurables.scss';
  import App from '../../App';

  function Configurables(props) {
    //console.log(JSON.stringify(props));
    //const plans = props.plans;
    //const boxHeight = props.boxHeight
    //const planUrl = props.planUrl;
    //const storeUrl = props.StoreUrl;
  
    return (
      renderConfigurablesItem(props)
    );
  }
  function getNamespaceOptions(metaData){
    let options = [];
    options.push({value:'',label:'Select'});

    for (const nameSpace in metaData) {
      options.push({value:nameSpace,label:nameSpace});
    }

    return options;
  }
  function getKeyOptions(namespaceItems){
    //console.log('getKeyOptions');
    //console.log(namespaceItems);
    let options = [];
    if(Array.isArray(namespaceItems)){
      for (let i = 0; i < namespaceItems.length; i++) {
        options.push({value:namespaceItems[i],label:namespaceItems[i]});
      }
    }
    return options;
  }
  function renderConfigurablesItem(props){

    const onChange = (value,attributeKey,fieldKey) => {
      //console.log('configurables onChange: '+value+' ak: '+attributeKey+' fk:'+fieldKey);
      props.change(value,attributeKey,fieldKey);
    }
    const onChangeTitle = (value,attributeKey) => {
      //console.log('configurables onChangeTitle: '+value+' ak: '+attributeKey);
      props.changeTitle(value,attributeKey);
    }
    const onSave = (attributeKey) => {
      //console.log('onSave ak: '+attributeKey);
      props.save(attributeKey);
    }

    switch(props.configurables.type) {
        case 'minMax':
          return <>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-1">
              <h3>
                {/*
                {(item.image != '' ? <img class="attribute-partner-image" src={item.image} alt={(item.name + " Image")} />:'')}
                */}
                <TextStyle variation="strong">{props.configurables.name}</TextStyle>
              </h3>
            </div>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-2">
              {props.configurables.status == "1"? <Badge status="success">Active</Badge>:<Badge>Inactive</Badge>}
            </div>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-3">
              <div className="iec-flex-container">
                <div className='configurable-half'>
                  <div className='configurable-half-field'>
                    <TextField
                        label={props.configurables.fields[0].label}
                        value={props.configurables.fields[0].value}
                        //onChange={handleChange}
                        //autoComplete="off"
                        step={1}
                        type="number"
                        onChange={(value) => {onChange(value,props.configurables.attribute_key,0)}}
                        disabled={
                          (
                            (
                              props.section == 'custom_attributes'
                              ||
                              props.section == 'partner_attributes'
                            )
                          )
                          &&
                          (
                            !props.permissions[props.section]
                          )
                        }
                    />   
                  </div>
                </div>
                <div className='configurable-half'>
                  <div className='configurable-half-field'>
                    <TextField
                        label={props.configurables.fields[1].label}
                        value={props.configurables.fields[1].value}
                        //onChange={handleChange}
                        //autoComplete="off"
                        step={1}
                        type="number"
                        onChange={(value) => {onChange(value,props.configurables.attribute_key,1)}}
                        disabled={
                          (
                            (
                              props.section == 'custom_attributes'
                              ||
                              props.section == 'partner_attributes'
                            )
                          )
                          &&
                          (
                            !props.permissions[props.section]
                          )
                        }
                    />  
                  </div> 
                  <div className='configurable-half-button'>
                    <Button disabled={(props.configurables.saveable == "1"? false:true)} primary onClick={() => {onSave(props.configurables.attribute_key)}}>Save</Button>               
                  </div>
                </div>
              </div>
              </div>                                              

            </>;
          case 'blank':
            return <>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-1">
              <h3>
                {/*
                {(item.image != '' ? <img class="attribute-partner-image" src={item.image} alt={(item.name + " Image")} />:'')}
                */}
                <TextStyle variation="strong">{props.configurables.name}</TextStyle>
              </h3>
            </div>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-2">
              {props.configurables.status == "1"? <Badge status="success">Active</Badge>:<Badge>Inactive</Badge>}
            </div>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-3">

            </div>   
            </>;
          case 'multiform':
              return <>
              <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-1">
                {(props.group == 'custom') ?<TextField
                    value={props.configurables.name}
                    onChange={(value) => {onChangeTitle(value,props.configurables.attribute_key)}}
                    autoComplete="off"
                    type="text"
                    label="Title"
                    labelHidden={false}
                    placeholder={'Attribute name'}
                    disabled={
                      (
                        (
                          props.section == 'custom_attributes'
                          ||
                          props.section == 'partner_attributes'
                        )
                      )
                      &&
                      (
                        !props.permissions[props.section]
                      )
                    }
                  /> :<h3><TextStyle variation="strong">{props.configurables.name}</TextStyle></h3> }
              </div>
              <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-2">
                {props.configurables.status == "1"? <Badge status="success">Active</Badge>:<Badge>Inactive</Badge>}
              </div>
              <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-3">
                <div className="attribute-multiform-container">
                  <div className="iec-flex-container">
                    <Select
                      onChange={(value) => {onChange(value,props.configurables.attribute_key,0)}}
                      label={props.configurables.fields[0].label}
                      options={props.configurables.fields[0].options}
                      value={props.configurables.fields[0].value}
                      labelHidden={false}
                      disabled={
                        (
                          (
                            props.section == 'custom_attributes'
                            ||
                            props.section == 'partner_attributes'
                          )
                        )
                        &&
                        (
                          !props.permissions[props.section]
                        )
                      }
                    />
                  </div>
                  <div className={((props.configurables.fields[0].value=='metafield'?'show':'hide')+" attributes-resource-item-meta-container")}>
                    <div className="iec-flex-container-meta">
                      <Select
                        onChange={(value) => {onChange(value,props.configurables.attribute_key,1)}}
                        label={props.configurables.fields[1].label}
                        options={getNamespaceOptions(props.metaData)}
                        value={props.configurables.fields[1].value}
                        labelHidden={false}
                        disabled={
                          (
                            (
                              props.section == 'custom_attributes'
                              ||
                              props.section == 'partner_attributes'
                            )
                          )
                          &&
                          (
                            !props.permissions[props.section]
                          )
                        }
                      />
                    </div>
                    <div className="iec-flex-container-meta">
                      <Select
                        onChange={(value) => {onChange(value,props.configurables.attribute_key,2)}}
                        label={props.configurables.fields[2].label}
                        options={getKeyOptions(props.metaData[props.configurables.fields[1].value])}
                        value={props.configurables.fields[2].value}
                        labelHidden={false}
                        disabled={
                          (
                            (
                              props.section == 'custom_attributes'
                              ||
                              props.section == 'partner_attributes'
                            )
                          )
                          &&
                          (
                            !props.permissions[props.section]
                          )
                        }
                      />
                    </div>                    
                  </div>
                  {
                    (
                      props.configurables.fields[3]
                      &&
                      props.configurables.fields[4]
                    )?
                    <div className="iec-flex-container">
                    <Select
                      onChange={(value) => {onChange(value,props.configurables.attribute_key,3)}}
                      label={props.configurables.fields[3].label}
                      options={props.configurables.fields[3].options}
                      value={props.configurables.fields[3].value}
                      labelHidden={true}
                      disabled={
                        (
                          (
                            props.section == 'custom_attributes'
                            ||
                            props.section == 'partner_attributes'
                          )
                        )
                        &&
                        (
                          !props.permissions[props.section]
                        )
                      }
                    />
                      <TextField
                        value={props.configurables.fields[4].value}
                        onChange={(value) => {onChange(value,props.configurables.attribute_key,4)}}
                        autoComplete="off"
                        type="text"
                        label="Value"
                        labelHidden={true}
                        placeholder={'Value to match'}
                        disabled={
                          (
                            (
                              props.section == 'custom_attributes'
                              ||
                              props.section == 'partner_attributes'
                            )
                          )
                          &&
                          (
                            !props.permissions[props.section]
                          )
                        }
                      /> 
                    <Button disabled={(props.configurables.saveable == "1"? false:true)} primary onClick={() => {onSave(props.configurables.attribute_key)}}>Save</Button>               

                 </div>
                 :
                 ''

                  }
                  
                </div>
                </div>   
              </>;
          case 'selectAndText':
                return <>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-1">
              <h3>
                {/*
                {(item.image != '' ? <img class="attribute-partner-image" src={item.image} alt={(item.name + " Image")} />:'')}
                */}
                <TextStyle variation="strong">{props.configurables.name}</TextStyle>
              </h3>
            </div>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-2">
              {props.configurables.status == "1"? <Badge status="success">Active</Badge>:<Badge>Inactive</Badge>}
            </div>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-3">
                <div className="attribute-ui-label">
                  <Label>{props.configurables.fields[0].label }</Label>
                </div>
              <div className="iec-flex-container attribute-select-container">
                <Select 
                  label={props.configurables.fields[0].label}
                  options={props.configurables.fields[0].options}
                  value={props.configurables.fields[0].value}
                  labelHidden={true}
                  onChange={(value) => {onChange(value,props.configurables.attribute_key,0)}}
                  disabled={
                    (
                      (
                        props.section == 'custom_attributes'
                        ||
                        props.section == 'partner_attributes'
                      )
                    )
                    &&
                    (
                      !props.permissions[props.section]
                    )
                  }
                />
                <TextField
                  value={props.configurables.fields[1].value}
                  autoComplete="off"
                  type="text"
                  label="Value"
                  labelHidden={true}
                  onChange={(value) => {onChange(value,props.configurables.attribute_key,1)}}
                  disabled={
                    (
                      (
                        props.section == 'custom_attributes'
                        ||
                        props.section == 'partner_attributes'
                      )
                    )
                    &&
                    (
                      !props.permissions[props.section]
                    )
                  }
                  /> 
                    <Button disabled={(props.configurables.saveable == "1"? false:true)} primary onClick={() => {onSave(props.configurables.attribute_key)}}>Save</Button>               
              </div>    
              </div>         
                </>;
          case 'select':
                return <>                                 
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-1">
              <h3>
                {/*
                {(item.image != '' ? <img class="attribute-partner-image" src={item.image} alt={(item.name + " Image")} />:'')}
                */}
                <TextStyle variation="strong">{props.configurables.name}</TextStyle>
              </h3>
            </div>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-2">
              {props.configurables.status == "1"? <Badge status="success">Active</Badge>:<Badge>Inactive</Badge>}
            </div>
            <div className="resource-item-col attributes-resource-item-col attributes-resource-item-col-3">
              <div class="attribute-select-container">
                <div className="attribute-ui-label">
                  <Label>{props.configurables.fields[0].label }</Label>
                </div>
                <Select 
                  label={props.configurables.fields[0].label}
                  options={props.configurables.fields[0].options}
                  value={props.configurables.fields[0].value}
                  labelHidden={true}
                  onChange={(value) => {onChange(value,props.configurables.attribute_key,0)}}
                  disabled={
                    (
                      (
                        props.section == 'custom_attributes'
                        ||
                        props.section == 'partner_attributes'
                      )
                    )
                    &&
                    (
                      !props.permissions[props.section]
                    )
                  }
                /> 
                    <Button disabled={(props.configurables.saveable == "1"? false:true)} primary onClick={() => {onSave(props.configurables.attribute_key)}}>Save</Button>               
              </div>
            </div>    
            </>;
            default:
          return '';
      }    
      return '';
  }

  export default Configurables;
