'use strict';

const metadata = {
  "AbandonedCartMajor": {
    "name": "abandoned cart",
    "set": "major",
    "description": "Used to represent a prospective purchase that a buyer didn’t complete.",
    "keywords": [
      "orders",
      "sales",
      "funnel"
    ]
  },
  "AccessibilityMajor": {
    "name": "accessibility",
    "set": "major",
    "description": "Used to represent accessibility information or features.",
    "keywords": [
      "accessibility",
      "usability",
      "a11y",
      "disability",
      "equal access",
      "universal design",
      "eye"
    ]
  },
  "ActivitiesMajor": {
    "name": "activities",
    "set": "major",
    "description": "Used as a navigation item in our emoji picker for the activities category.",
    "keywords": [
      "emoji",
      "navigation",
      "football",
      "ball",
      "activity"
    ]
  },
  "AddCodeMajor": {
    "name": "add code",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AddImageMajor": {
    "name": "add image",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AddMajor": {
    "name": "add",
    "set": "major",
    "description": "Used as an action to add a new content block or layout component.",
    "keywords": [
      "add",
      "new",
      "block"
    ]
  },
  "AddNoteMajor": {
    "name": "add note",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AddProductMajor": {
    "name": "add product",
    "set": "major",
    "description": "Used as an action to add a new product.",
    "keywords": [
      "add",
      "product",
      "price tag"
    ]
  },
  "AdjustMinor": {
    "name": "adjust",
    "set": "minor",
    "description": "Used to denote that an adjustment can be made.",
    "keywords": [
      "adjust",
      "adjustment",
      "controls",
      "dials"
    ]
  },
  "AffiliateMajor": {
    "name": "affiliate",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AlertMinor": {
    "name": "alert",
    "set": "minor",
    "description": "Used to give merchants more information about something they should be aware of.",
    "keywords": [
      "attention",
      "alert",
      "warning",
      "exclamation",
      "bang"
    ]
  },
  "AnalyticsMajor": {
    "name": "analytics",
    "set": "major",
    "description": "Used to represent analytics or data.",
    "keywords": [
      "analytics",
      "data",
      "graph",
      "reports"
    ]
  },
  "AnalyticsMinor": {
    "name": "analytics",
    "set": "minor",
    "description": "Used to represent analytics or data.",
    "keywords": [
      "analytics",
      "data",
      "graph",
      "reports"
    ]
  },
  "AppExtensionMinor": {
    "name": "app extension",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AppsMajor": {
    "name": "apps",
    "set": "major",
    "description": "Used to represent partner apps.",
    "keywords": [
      "add",
      "apps",
      "applications",
      "blocks",
      "embedded",
      "extensions"
    ]
  },
  "AppsMinor": {
    "name": "apps",
    "set": "minor",
    "description": "Used to represent partner apps.",
    "keywords": [
      "add",
      "apps",
      "applications",
      "blocks",
      "embedded",
      "extensions"
    ]
  },
  "ArchiveMajor": {
    "name": "archive",
    "set": "major",
    "description": "Used to represent archiving an item or resource.",
    "keywords": [
      "archive",
      "box"
    ]
  },
  "ArchiveMinor": {
    "name": "archive",
    "set": "minor",
    "description": "Used to denote the action of archiving an item or resource.",
    "keywords": [
      "archive",
      "box"
    ]
  },
  "ArrowDownMinor": {
    "name": "arrow down",
    "set": "minor",
    "description": "Used to represent a negative trend when looking at analytical information.",
    "keywords": [
      "arrow",
      "down"
    ]
  },
  "ArrowLeftMinor": {
    "name": "arrow left",
    "set": "minor",
    "description": "Used to indicate that merchants will be directed to the previous page.",
    "keywords": [
      "arrow",
      "left",
      "previous"
    ]
  },
  "ArrowRightMinor": {
    "name": "arrow right",
    "set": "minor",
    "description": "Used to indicate that merchants will be directed to the next page.",
    "keywords": [
      "arrow",
      "right",
      "next"
    ]
  },
  "ArrowUpMinor": {
    "name": "arrow up",
    "set": "minor",
    "description": "Used to represent a positive trend when looking at analytical information.",
    "keywords": [
      "arrow",
      "up"
    ]
  },
  "AttachmentMajor": {
    "name": "attachment",
    "set": "major",
    "description": "Used to represent an attachment.",
    "keywords": [
      "attachment",
      "paper clip",
      "files"
    ]
  },
  "AutomationMajor": {
    "name": "automation",
    "set": "major",
    "description": "Used to represent automation, or a task that can be automated.",
    "keywords": [
      "automation",
      "cog",
      "automated",
      "gear"
    ]
  },
  "BackspaceMajor": {
    "name": "backspace",
    "set": "major",
    "description": "Used to represent backspace on a mobile keyboard.",
    "keywords": [
      "backspace",
      "x",
      "delete"
    ]
  },
  "BalanceMajor": {
    "name": "balance",
    "set": "major",
    "description": "The account’s current balance. This amount is comprised of any transaction not yet included in a payout.",
    "keywords": [
      "balance",
      "wallet",
      "money",
      "transaction",
      "payout"
    ]
  },
  "BankMajor": {
    "name": "bank",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BarcodeMajor": {
    "name": "barcode",
    "set": "major",
    "description": "Used to represent a barcode.",
    "keywords": [
      "barcode",
      "scanner"
    ]
  },
  "BehaviorMajor": {
    "name": "behavior",
    "set": "major",
    "description": "Used to represent a user clicking, or interacting with something.",
    "keywords": [
      "click",
      "cursor"
    ]
  },
  "BillingStatementDollarMajor": {
    "name": "billing statement (dollar)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BillingStatementEuroMajor": {
    "name": "billing statement (euro)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BillingStatementPoundMajor": {
    "name": "billing statement (pound)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BillingStatementRupeeMajor": {
    "name": "billing statement (rupee)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BillingStatementYenMajor": {
    "name": "billing statement (yen)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BlockMinor": {
    "name": "block",
    "set": "minor",
    "description": "Used to represent a content block as a sub-element of a section, page or layout.",
    "keywords": [
      "block",
      "element",
      "item",
      "layout",
      "content"
    ]
  },
  "BlockquoteMajor": {
    "name": "blockquote",
    "set": "major",
    "description": "Used to represent a quote.",
    "keywords": [
      "blockquote",
      "testimonials",
      "quote",
      "speech",
      "text",
      "sections",
      "writing",
      "content"
    ]
  },
  "BlogMajor": {
    "name": "blog",
    "set": "major",
    "description": "Used to represent a blog post, or something being written.",
    "keywords": [
      "author",
      "blog",
      "pen",
      "pencil"
    ]
  },
  "BugMajor": {
    "name": "bug",
    "set": "major",
    "description": "Used to represent a bug in code.",
    "keywords": [
      "bug",
      "insect"
    ]
  },
  "ButtonCornerPillMajor": {
    "name": "button corner pill",
    "set": "major",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "pill",
      "email",
      "editor"
    ]
  },
  "ButtonCornerRoundedMajor": {
    "name": "button corner rounded",
    "set": "major",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "rounded",
      "email",
      "editor"
    ]
  },
  "ButtonCornerSquareMajor": {
    "name": "button corner square",
    "set": "major",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "square",
      "email",
      "editor"
    ]
  },
  "ButtonMinor": {
    "name": "button",
    "set": "minor",
    "description": "Used to represent a button block appearing as a sub-element of a section, page or layout.",
    "keywords": [
      "button",
      "press",
      "click",
      "buy button",
      "block"
    ]
  },
  "BuyButtonButtonLayoutMajor": {
    "name": "buy button button layout",
    "set": "major",
    "description": "Used to represent a centered layout for our Buy Button.",
    "keywords": [
      "center",
      "layout"
    ]
  },
  "BuyButtonHorizontalLayoutMajor": {
    "name": "buy button horizontal layout",
    "set": "major",
    "description": "Used to represent a horizontal layout for our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "layout"
    ]
  },
  "BuyButtonMajor": {
    "name": "buy button",
    "set": "major",
    "description": "Used to represent our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "press"
    ]
  },
  "BuyButtonVerticalLayoutMajor": {
    "name": "buy button vertical layout",
    "set": "major",
    "description": "Used to represent a vertical layout for our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "layout"
    ]
  },
  "CalendarMajor": {
    "name": "calendar",
    "set": "major",
    "description": "Used to represent a calendar.",
    "keywords": [
      "calendar"
    ]
  },
  "CalendarMinor": {
    "name": "calendar",
    "set": "minor",
    "description": "Used to denote the action of opening a date picker.",
    "keywords": [
      "calendar",
      "date",
      "time",
      "month",
      "year",
      "day"
    ]
  },
  "CalendarTickMajor": {
    "name": "calendar tick",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "CameraMajor": {
    "name": "camera",
    "set": "major",
    "description": "Used to represent a camera.",
    "keywords": [
      "camera",
      "photo"
    ]
  },
  "CancelSmallMinor": {
    "name": "cancel small",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "cancel",
      "stop",
      "undo",
      "remove",
      "x"
    ]
  },
  "CapitalMajor": {
    "name": "capital",
    "set": "major",
    "description": "Used to help direct merchants to the Capital page",
    "keywords": [
      "capital",
      "flower",
      "plant"
    ]
  },
  "CapturePaymentMinor": {
    "name": "capture payment",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "CardReaderChipMajor": {
    "name": "card reader chip",
    "set": "major",
    "description": "Used to represent a card chip reader.",
    "keywords": [
      "credit card",
      "payment"
    ]
  },
  "CardReaderMajor": {
    "name": "card reader",
    "set": "major",
    "description": "Used to represent the Shopify Tap and Chip reader.",
    "keywords": [
      "chip and swipe",
      "card reader",
      "POS"
    ]
  },
  "CardReaderTapMajor": {
    "name": "card reader tap",
    "set": "major",
    "description": "Used to represent the Shopify Tap and Chip reader.",
    "keywords": [
      "tap and chip",
      "card reader",
      "POS"
    ]
  },
  "CaretDownMinor": {
    "name": "caret down",
    "set": "minor",
    "description": "Used to denote the action of expanding a section to reveal more content, like a popover or an accordion. Also used to represent sorting order.",
    "keywords": [
      "caret",
      "down",
      "open"
    ]
  },
  "CaretUpMinor": {
    "name": "caret up",
    "set": "minor",
    "description": "Used to denote the action of contracting a section to hide additional content, like an accordion. Also used to represent sorting order.",
    "keywords": [
      "caret",
      "up",
      "close"
    ]
  },
  "CartDownMajor": {
    "name": "cart down",
    "set": "major",
    "description": "Used to represent saving the contents of a shopping cart.",
    "keywords": [
      "cart",
      "checkout"
    ]
  },
  "CartMajor": {
    "name": "cart",
    "set": "major",
    "description": "Used to represent a shopping cart.",
    "keywords": [
      "cart",
      "checkout",
      "shopping"
    ]
  },
  "CartUpMajor": {
    "name": "cart up",
    "set": "major",
    "description": "Used to represent retrieving the contents of saved shopping cart.",
    "keywords": [
      "cart",
      "checkout"
    ]
  },
  "CashDollarMajor": {
    "name": "cash (dollar)",
    "set": "major",
    "description": "Used to represent Dollar currency.",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashEuroMajor": {
    "name": "cash (euro)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashPoundMajor": {
    "name": "cash (pound)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashRupeeMajor": {
    "name": "cash (rupee)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashYenMajor": {
    "name": "cash (yen)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CategoriesMajor": {
    "name": "categories",
    "set": "major",
    "description": "Used to represent either list of categories or files.",
    "keywords": [
      "categories",
      "files"
    ]
  },
  "ChannelsMajor": {
    "name": "channels",
    "set": "major",
    "description": "Used to represent channels, or items connected by a common root.",
    "keywords": [
      "channels",
      "connect",
      "connected",
      "path",
      "related"
    ]
  },
  "ChatMajor": {
    "name": "chat",
    "set": "major",
    "description": "Used to represent a conversation, or verbal communication.",
    "keywords": [
      "chat",
      "speech bubble",
      "message",
      "talk"
    ]
  },
  "ChecklistAlternateMajor": {
    "name": "checklist alternate",
    "set": "major",
    "description": "Used to represent a checklist.",
    "keywords": [
      "checklist",
      "list"
    ]
  },
  "ChecklistMajor": {
    "name": "checklist",
    "set": "major",
    "description": "Used to represent a completed checklist.",
    "keywords": [
      "checklist",
      "complete"
    ]
  },
  "CheckoutMajor": {
    "name": "checkout",
    "set": "major",
    "description": "Used to represent a shopping cart.",
    "keywords": [
      "checkout",
      "cart",
      "shopping"
    ]
  },
  "ChevronDownMinor": {
    "name": "chevron down",
    "set": "minor",
    "description": "Used to denote the action of expanding a section to reveal more content.",
    "keywords": [
      "chevron",
      "down"
    ]
  },
  "ChevronLeftMinor": {
    "name": "chevron left",
    "set": "minor",
    "description": "Used to indicate that merchants will be directed to their previous location or to navigate to a previous item.",
    "keywords": [
      "chevron",
      "left"
    ]
  },
  "ChevronRightMinor": {
    "name": "chevron right",
    "set": "minor",
    "description": "Used to indicate that merchants will be directed to the next item.",
    "keywords": [
      "chevron",
      "right"
    ]
  },
  "ChevronUpMinor": {
    "name": "chevron up",
    "set": "minor",
    "description": "Used to denote the action of contracting a section to hide additional content.",
    "keywords": [
      "chevron",
      "up"
    ]
  },
  "CircleAlertMajor": {
    "name": "circle alert",
    "set": "major",
    "description": "Used to give merchants more information about something they should be aware of.",
    "keywords": [
      "attention",
      "alert",
      "warning",
      "exclamation",
      "bang",
      "circle",
      "round"
    ]
  },
  "CircleCancelMajor": {
    "name": "circle cancel",
    "set": "major",
    "description": "Used to represent an action to cancel or remove an item or resource.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "x"
    ]
  },
  "CircleCancelMinor": {
    "name": "circle cancel",
    "set": "minor",
    "description": "Used to represent an action to cancel or remove an item or resource.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "x"
    ]
  },
  "CircleChevronDownMinor": {
    "name": "circle chevron down",
    "set": "minor",
    "description": "Used to represent a collapsible section, or an action to navigate down.",
    "keywords": [
      "chevron",
      "down",
      "circle",
      "outline"
    ]
  },
  "CircleChevronLeftMinor": {
    "name": "circle chevron left",
    "set": "minor",
    "description": "Used to represent an action to navigate back.",
    "keywords": [
      "back",
      "chevron",
      "left",
      "circle",
      "outline"
    ]
  },
  "CircleChevronRightMinor": {
    "name": "circle chevron right",
    "set": "minor",
    "description": "Used to help direct merchants from a item’s name in a list to the item’s show page.",
    "keywords": [
      "chevron",
      "right",
      "circle",
      "outline"
    ]
  },
  "CircleChevronUpMinor": {
    "name": "circle chevron up",
    "set": "minor",
    "description": "Used to represent a collapsible section, or an action to navigate up.",
    "keywords": [
      "chevron",
      "up",
      "circle",
      "outline"
    ]
  },
  "CircleDisabledMajor": {
    "name": "circle disabled",
    "set": "major",
    "description": "Used to represent an item or resource that is disabled, or an action that is not allowed.",
    "keywords": [
      "blocked",
      "disabled"
    ]
  },
  "CircleDisableMinor": {
    "name": "circle disable",
    "set": "minor",
    "description": "Used to denote the action of disabling something, like a discount code.",
    "keywords": [
      "stop",
      "not permitted",
      "not allowed",
      "error",
      "no",
      "circle",
      "round",
      "disabled",
      "barred"
    ]
  },
  "CircleDotsMajor": {
    "name": "circle dots",
    "set": "major",
    "description": "Used to represent an action to reveal a menu, or more options.",
    "keywords": [
      "ellipsis",
      "options",
      "overflow"
    ]
  },
  "CircleDownMajor": {
    "name": "circle down",
    "set": "major",
    "description": "Used to represent downwards navigation, or that something is below it.",
    "keywords": [
      "arrow",
      "down"
    ]
  },
  "CircleInformationMajor": {
    "name": "circle information",
    "set": "major",
    "description": "Used to represent a hint, or draw attention to a piece of information.",
    "keywords": [
      "info",
      "information",
      "hint"
    ]
  },
  "CircleLeftMajor": {
    "name": "circle left",
    "set": "major",
    "description": "Used to represent backwards naviagation, or that something is before it.",
    "keywords": [
      "arrow",
      "back"
    ]
  },
  "CircleMinusMajor": {
    "name": "circle minus",
    "set": "major",
    "description": "Used to represent an action to remove an item or resource, or decrease the quantity of an item or resource.",
    "keywords": [
      "less",
      "minus",
      "remove"
    ]
  },
  "CircleMinusMinor": {
    "name": "circle minus",
    "set": "minor",
    "description": "Used to represent an action to remove an item or resource, or decrease the quantity of an item or resource.",
    "keywords": [
      "less",
      "minus",
      "remove"
    ]
  },
  "CircleMinusOutlineMinor": {
    "name": "circle minus outline",
    "set": "minor",
    "description": "Used to represent an action to remove an item or resource, or decrease the quantity of an item or resource.",
    "keywords": [
      "less",
      "minus",
      "remove"
    ]
  },
  "CirclePlusMajor": {
    "name": "circle plus",
    "set": "major",
    "description": "Similar to the plus icons, used to indicate adding something.",
    "keywords": [
      "add",
      "plus",
      "circle",
      "resource"
    ]
  },
  "CirclePlusMinor": {
    "name": "circle plus",
    "set": "minor",
    "description": "Used to represent an action to add an item or resource, or increase the quantity of an item or resource.",
    "keywords": [
      "add",
      "more",
      "plus"
    ]
  },
  "CirclePlusOutlineMinor": {
    "name": "circle plus outline",
    "set": "minor",
    "description": "Used to denote the action of adding new content, like adding a new variant option name in the mobile app.",
    "keywords": [
      "plus",
      "circle",
      "outline",
      "+"
    ]
  },
  "CircleRightMajor": {
    "name": "circle right",
    "set": "major",
    "description": "Used to represent forwards naviagation, or that something is after it.",
    "keywords": [
      "arrow",
      "forward"
    ]
  },
  "CircleTickMajor": {
    "name": "circle tick",
    "set": "major",
    "description": "Used to represent an action to approve or confirm.",
    "keywords": [
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "CircleTickMinor": {
    "name": "circle tick",
    "set": "minor",
    "description": "Used to represent an action to approve or confirm.",
    "keywords": [
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "CircleTickOutlineMinor": {
    "name": "circle tick outline",
    "set": "minor",
    "description": "Used to represent an action to approve or confirm.",
    "keywords": [
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "CircleUpMajor": {
    "name": "circle up",
    "set": "major",
    "description": "Used to represent upwards naviagation, or that something is above it.",
    "keywords": [
      "arrow",
      "up"
    ]
  },
  "ClipboardMinor": {
    "name": "clipboard",
    "set": "minor",
    "description": "Used to represent a clipboard, usually accompanying a copy action.",
    "keywords": [
      "clipboard",
      "copy"
    ]
  },
  "ClockMajor": {
    "name": "clock",
    "set": "major",
    "description": "Used to represent a clock, or the time.",
    "keywords": [
      "time",
      "clock",
      "watch",
      "minute",
      "second",
      "hour",
      "stopwatch",
      "circle"
    ]
  },
  "ClockMinor": {
    "name": "clock",
    "set": "minor",
    "description": "Used to indicate time.",
    "keywords": [
      "time",
      "clock",
      "watch",
      "minute",
      "second",
      "hour",
      "stopwatch",
      "circle"
    ]
  },
  "CodeMajor": {
    "name": "code",
    "set": "major",
    "description": "Used to represent programming.",
    "keywords": [
      "code",
      "block",
      "liquid",
      "script",
      "syntax"
    ]
  },
  "CollectionsMajor": {
    "name": "collections",
    "set": "major",
    "description": "Used to represent a collection of products.",
    "keywords": [
      "collection",
      "tag",
      "tags",
      "swing"
    ]
  },
  "ColorNoneMinor": {
    "name": "color none",
    "set": "minor",
    "description": "Used to represent a lack of color, or that a color is not allowed or available.",
    "keywords": [
      "color",
      "drop",
      "droplet",
      "water",
      "strike",
      "line",
      "no",
      "crossed"
    ]
  },
  "ColorsMajor": {
    "name": "colors",
    "set": "major",
    "description": "Used to represent a color swatch, or palette of colors.",
    "keywords": [
      "color",
      "palette",
      "swatch"
    ]
  },
  "Column1Major": {
    "name": "column 1",
    "set": "major",
    "description": "Used to represent a 1 column layout.",
    "keywords": [
      "single column",
      "column",
      "layout",
      "email"
    ]
  },
  "Columns2Major": {
    "name": "columns 2",
    "set": "major",
    "description": "Used to represent a 2 column layout.",
    "keywords": [
      "two columns",
      "column",
      "layout",
      "email"
    ]
  },
  "Columns3Major": {
    "name": "columns 3",
    "set": "major",
    "description": "Used to represent a 3 column layout.",
    "keywords": [
      "three columns",
      "column",
      "layout",
      "email"
    ]
  },
  "Columns3Minor": {
    "name": "columns 3",
    "set": "minor",
    "description": "Used to represent a 3 column layout or an action to hide or show columns",
    "keywords": [
      "three columns",
      "column",
      "options",
      "layout"
    ]
  },
  "ColumnWithTextMajor": {
    "name": "column with text",
    "set": "major",
    "description": "Used to represent a layout option of two columns, each featuring an image and text.",
    "keywords": [
      "paper",
      "page",
      "content",
      "featured",
      "section",
      "columns",
      "text",
      "image",
      "photo",
      "picture",
      "writing",
      "copy"
    ]
  },
  "ComposeMajor": {
    "name": "compose",
    "set": "major",
    "description": "Used to denote the action of composing a new message.",
    "keywords": [
      "compose",
      "message",
      "write",
      "pencil",
      "pen"
    ]
  },
  "ConfettiMajor": {
    "name": "confetti",
    "set": "major",
    "description": "Used to represent a moment of celebration, or to call attention to something fun or new.",
    "keywords": [
      "celebrate",
      "confetti",
      "tada"
    ]
  },
  "ConnectMinor": {
    "name": "connect",
    "set": "minor",
    "description": "Used to represent a connection between two items or resources.",
    "keywords": [
      "connect",
      "connected",
      "path",
      "join",
      "related"
    ]
  },
  "ConversationMinor": {
    "name": "conversation",
    "set": "minor",
    "description": "Used to give merchants an indication of comments attached to an order.",
    "keywords": [
      "speech",
      "bubble",
      "conversation",
      "talk",
      "chat",
      "comment"
    ]
  },
  "CreditCardCancelMajor": {
    "name": "credit card cancel",
    "set": "major",
    "description": "Used to represent a cancellation related to a charge",
    "keywords": [
      "card",
      "credit card",
      "payment",
      "credit card cancel"
    ]
  },
  "CreditCardMajor": {
    "name": "credit card",
    "set": "major",
    "description": "Used to represent a credit card.",
    "keywords": [
      "card",
      "credit card",
      "payment"
    ]
  },
  "CreditCardPercentMajor": {
    "name": "credit card percent",
    "set": "major",
    "description": "Used to represent a credit card interest.",
    "keywords": [
      "card",
      "credit card",
      "interest",
      "payment"
    ]
  },
  "CreditCardSecureMajor": {
    "name": "credit card secure",
    "set": "major",
    "description": "Used to represent a secured credit card.",
    "keywords": [
      "card",
      "credit card",
      "payment",
      "secure"
    ]
  },
  "CurrencyConvertMinor": {
    "name": "currency convert",
    "set": "minor",
    "description": "Used to represent currency conversion.",
    "keywords": [
      "currency",
      "exchange",
      "forex"
    ]
  },
  "CustomerMinusMajor": {
    "name": "customer minus",
    "set": "major",
    "description": "Used to represent removing a customer, or user.",
    "keywords": [
      "remove",
      "user"
    ]
  },
  "CustomerPlusMajor": {
    "name": "customer plus",
    "set": "major",
    "description": "Used to represent adding a customer, or user.",
    "keywords": [
      "add",
      "user"
    ]
  },
  "CustomersMajor": {
    "name": "customers",
    "set": "major",
    "description": "Used to represent a customer, or user.",
    "keywords": [
      "customer",
      "user"
    ]
  },
  "CustomersMinor": {
    "name": "customers",
    "set": "minor",
    "description": "Used to represent a customer, or user.",
    "keywords": [
      "customer",
      "user"
    ]
  },
  "DataVisualizationMajor": {
    "name": "data visualization",
    "set": "major",
    "description": "Used to represent a presentation or graph.",
    "keywords": [
      "graph",
      "presentation"
    ]
  },
  "DeleteMajor": {
    "name": "delete",
    "set": "major",
    "description": "Used to represent a trash can, or an action to remove or delete an item or resource.",
    "keywords": [
      "delete",
      "remove",
      "trash"
    ]
  },
  "DeleteMinor": {
    "name": "delete",
    "set": "minor",
    "description": "Used to denote a destructive action to delete an item.",
    "keywords": [
      "delete",
      "remove",
      "trash",
      "garbage",
      "get rid of"
    ]
  },
  "DesktopMajor": {
    "name": "desktop",
    "set": "major",
    "description": "Used to represent a large screen or desktop computer.",
    "keywords": [
      "desktop",
      "screen"
    ]
  },
  "DetailedPopUpMajor": {
    "name": "detailed pop up",
    "set": "major",
    "description": "Used to represent the option to popup the content.",
    "keywords": [
      "popup",
      "window",
      "overlay"
    ]
  },
  "DiamondAlertMajor": {
    "name": "diamond alert",
    "set": "major",
    "description": "Used to alert merchants on information they should be aware of.",
    "keywords": [
      "alert",
      "attention",
      "critical"
    ]
  },
  "DigitalMediaReceiverMajor": {
    "name": "digital media receiver",
    "set": "major",
    "description": "Used to represent a digital receiver or wireless network device.",
    "keywords": [
      "receiver",
      "wifi",
      "wireless"
    ]
  },
  "DiscountAutomaticMajor": {
    "name": "discount automatic",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DiscountCodeMajor": {
    "name": "discount code",
    "set": "major",
    "description": "Used to represent a discount code or coupon.",
    "keywords": [
      "coupon",
      "discount"
    ]
  },
  "DiscountsMajor": {
    "name": "discounts",
    "set": "major",
    "description": "Used to represent a discount.",
    "keywords": [
      "discount"
    ]
  },
  "DiscountsMinor": {
    "name": "discounts",
    "set": "minor",
    "description": "Used to represent a discount.",
    "keywords": [
      "discount"
    ]
  },
  "DisputeMinor": {
    "name": "dispute",
    "set": "minor",
    "description": "Used to represent a dispute or important conversation or notification.",
    "keywords": [
      "dispute",
      "claim"
    ]
  },
  "DnsSettingsMajor": {
    "name": "dns settings",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DomainNewMajor": {
    "name": "domain new",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DomainRedirectMinor": {
    "name": "domain redirect",
    "set": "minor",
    "description": "Used to represent a redirect domain.",
    "keywords": [
      "domain",
      "redirect"
    ]
  },
  "DomainsMajor": {
    "name": "domains",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DraftOrdersMajor": {
    "name": "draft orders",
    "set": "major",
    "description": "Used to represent an order that is in a Draft state.",
    "keywords": [
      "draft",
      "order",
      "pending"
    ]
  },
  "DragDropMajor": {
    "name": "drag drop",
    "set": "major",
    "description": "Used to represent drag and drop.",
    "keywords": [
      "drag",
      "drop",
      "files",
      "copy"
    ]
  },
  "DragHandleMinor": {
    "name": "drag handle",
    "set": "minor",
    "description": "Used to represent drag handles.",
    "keywords": [
      "drag",
      "draggable",
      "grab",
      "reposition"
    ]
  },
  "DropdownMinor": {
    "name": "dropdown",
    "set": "minor",
    "description": "Used to represent there is dropdown content",
    "keywords": [
      "dropdown",
      "select"
    ]
  },
  "DuplicateMinor": {
    "name": "duplicate",
    "set": "minor",
    "description": "Used to denote the action of duplicating orders, to save as (reports), and to copy content to clipboard like an address.",
    "keywords": [
      "duplicate",
      "copy",
      "make another one",
      "two",
      "duo"
    ]
  },
  "EditMajor": {
    "name": "edit",
    "set": "major",
    "description": "Used to represent an action to edit an item or resource.",
    "keywords": [
      "edit",
      "pen",
      "pencil",
      "write"
    ]
  },
  "EditMinor": {
    "name": "edit",
    "set": "minor",
    "description": "Used to represent the action of editing or modifying information.",
    "keywords": [
      "pencil",
      "pen",
      "paper",
      "edit",
      "page",
      "change"
    ]
  },
  "EmailMajor": {
    "name": "email",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "email",
      "letter",
      "mail",
      "rectangle",
      "invite"
    ]
  },
  "EmailNewsletterMajor": {
    "name": "email newsletter",
    "set": "major",
    "description": "Used to represent an opened email or letter.",
    "keywords": [
      "email",
      "letter",
      "opened",
      "read"
    ]
  },
  "EmbedMinor": {
    "name": "embed",
    "set": "minor",
    "description": "Used to represent an object embedded from a web resource.",
    "keywords": [
      "embed",
      "web resource",
      "web",
      "iframe"
    ]
  },
  "EnableSelectionMinor": {
    "name": "enable selection",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "checkmark",
      "select"
    ]
  },
  "EnvelopeMajor": {
    "name": "envelope",
    "set": "major",
    "description": "Used to represent an envelope that merchants can use to ship orders to their customers.",
    "keywords": [
      "shipping",
      "packaging",
      "envelope"
    ]
  },
  "ExchangeMajor": {
    "name": "exchange",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ExistingInventoryMajor": {
    "name": "existing inventory",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ExitMajor": {
    "name": "exit",
    "set": "major",
    "description": "Used to denote the action of exiting an app, channel, or workflow.",
    "keywords": [
      "exit",
      "quit",
      "leave",
      "out"
    ]
  },
  "ExportMinor": {
    "name": "export",
    "set": "minor",
    "description": "Used to denote the action of exporting content.",
    "keywords": [
      "export",
      "take out",
      "resource"
    ]
  },
  "ExternalMinor": {
    "name": "external",
    "set": "minor",
    "description": "Used to denote the action of navigating to an external resource.",
    "keywords": [
      "external",
      "outside",
      "not here"
    ]
  },
  "ExternalSmallMinor": {
    "name": "external small",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "FaviconMajor": {
    "name": "favicon",
    "set": "major",
    "description": "Used to represent a favicon.",
    "keywords": [
      "favicon",
      "ico",
      "icon"
    ]
  },
  "FavoriteMajor": {
    "name": "favorite",
    "set": "major",
    "description": "Used to represent an action to favorite or save an item or resource.",
    "keywords": [
      "favorite",
      "favourite",
      "save",
      "star",
      "starred"
    ]
  },
  "FeaturedCollectionMajor": {
    "name": "featured collection",
    "set": "major",
    "description": "Used to represent a featured or favorite collection.",
    "keywords": [
      "collection",
      "favorite",
      "favourite",
      "featured"
    ]
  },
  "FeaturedContentMajor": {
    "name": "featured content",
    "set": "major",
    "description": "Used to represent a featured or favorite page or content item.",
    "keywords": [
      "favourite",
      "favorite",
      "feature"
    ]
  },
  "FilterMajor": {
    "name": "filter",
    "set": "major",
    "description": "Used to represent an action to filter a list of items or resources.",
    "keywords": [
      "filter",
      "options"
    ]
  },
  "FinancesMajor": {
    "name": "finances",
    "set": "major",
    "description": "Used to represent the Finances section.",
    "keywords": [
      "balance",
      "billing",
      "finances",
      "money",
      "payout"
    ]
  },
  "FinancesMinor": {
    "name": "finances",
    "set": "minor",
    "description": "Used to represent the Finances section.",
    "keywords": [
      "balance",
      "billing",
      "finances",
      "money",
      "payout"
    ]
  },
  "FirstOrderMajor": {
    "name": "first order",
    "set": "major",
    "description": "Used to represent a first order.",
    "keywords": [
      "celebrate",
      "first",
      "milestone",
      "order"
    ]
  },
  "FirstVisitMajor": {
    "name": "first visit",
    "set": "major",
    "description": "Used to represent a first view or visitor.",
    "keywords": [
      "first",
      "view",
      "visitor"
    ]
  },
  "FlagMajor": {
    "name": "flag",
    "set": "major",
    "description": "Used to represent a flag.",
    "keywords": [
      "flag"
    ]
  },
  "FlipCameraMajor": {
    "name": "flip camera",
    "set": "major",
    "description": "Used to represent an action to flip a mobile phone camera.",
    "keywords": [
      "camera",
      "flip",
      "selfie"
    ]
  },
  "FolderDownMajor": {
    "name": "folder down",
    "set": "major",
    "description": "Used to represent an action to download a folder.",
    "keywords": [
      "download",
      "folder"
    ]
  },
  "FolderMajor": {
    "name": "folder",
    "set": "major",
    "description": "Used to represent a folder.",
    "keywords": [
      "folder"
    ]
  },
  "FolderMinusMajor": {
    "name": "folder minus",
    "set": "major",
    "description": "Used to represent an action to remove a folder.",
    "keywords": [
      "folder",
      "minus",
      "remove"
    ]
  },
  "FolderPlusMajor": {
    "name": "folder plus",
    "set": "major",
    "description": "Used to represent an action to add a folder.",
    "keywords": [
      "add",
      "folder",
      "plus"
    ]
  },
  "FolderUpMajor": {
    "name": "folder up",
    "set": "major",
    "description": "Used to represent an action to upload a folder.",
    "keywords": [
      "folder",
      "upload"
    ]
  },
  "FollowUpEmailMajor": {
    "name": "follow up email",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "FoodMajor": {
    "name": "food",
    "set": "major",
    "description": "Used as a navigation item in our emoji picker for the food category.",
    "keywords": [
      "emoji",
      "navigation",
      "coffee",
      "food"
    ]
  },
  "FooterMajor": {
    "name": "footer",
    "set": "major",
    "description": "Used to represent the footer section of a component, page or layout.",
    "keywords": [
      "layout",
      "footer",
      "content",
      "dashed",
      "bottom",
      "section"
    ]
  },
  "FormsMajor": {
    "name": "forms",
    "set": "major",
    "description": "Used to represent a text input for a form.",
    "keywords": [
      "form",
      "input",
      "text"
    ]
  },
  "FraudProtectMajor": {
    "name": "fraud protect",
    "set": "major",
    "description": "Used to represent that an order is protected by Fraud Protect from chargebacks due to fraud.",
    "keywords": [
      "fraud protect",
      "protected",
      "risk",
      "fraud"
    ]
  },
  "FraudProtectMinor": {
    "name": "fraud protect",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "FraudProtectPendingMajor": {
    "name": "fraud protect pending",
    "set": "major",
    "description": "Used to represent that the Fraud Protect status is pending.",
    "keywords": [
      "fraud protect",
      "pending",
      "chargebacks",
      "risk",
      "fraud"
    ]
  },
  "FraudProtectPendingMinor": {
    "name": "fraud protect pending",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "FraudProtectUnprotectedMajor": {
    "name": "fraud protect unprotected",
    "set": "major",
    "description": "Used to represent that an order is not protected by Fraud Protect from chargebacks due to fraud.",
    "keywords": [
      "fraud protect",
      "chargebacks",
      "unprotected",
      "not protected",
      "risk",
      "fraud"
    ]
  },
  "FraudProtectUnprotectedMinor": {
    "name": "fraud protect unprotected",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "GamesConsoleMajor": {
    "name": "games console",
    "set": "major",
    "description": "Used to represent a console controller.",
    "keywords": [
      "console",
      "controller",
      "games"
    ]
  },
  "GiftCardMajor": {
    "name": "gift card",
    "set": "major",
    "description": "Used to represent a gift card or present.",
    "keywords": [
      "gift",
      "gift card",
      "present"
    ]
  },
  "GiftCardMinor": {
    "name": "gift card",
    "set": "minor",
    "description": "Used to represent a gift card or present.",
    "keywords": [
      "gift",
      "gift card",
      "present"
    ]
  },
  "GlobeMajor": {
    "name": "globe",
    "set": "major",
    "description": "Used to represent a globe.",
    "keywords": [
      "globe"
    ]
  },
  "GlobeMinor": {
    "name": "globe",
    "set": "minor",
    "description": "Used to represent a globe.",
    "keywords": [
      "globe"
    ]
  },
  "GrammarMajor": {
    "name": "grammar",
    "set": "major",
    "description": "Used to represent correct grammar or a spell check.",
    "keywords": [
      "grammar",
      "spell check",
      "spelling"
    ]
  },
  "HashtagMajor": {
    "name": "hashtag",
    "set": "major",
    "description": "Used to represent a hashtag.",
    "keywords": [
      "pound",
      "#",
      "sharp",
      "num"
    ]
  },
  "HeaderMajor": {
    "name": "header",
    "set": "major",
    "description": "Used to represent the header section of a component, page or layout.",
    "keywords": [
      "layout",
      "header",
      "content",
      "dashed",
      "section"
    ]
  },
  "HeartMajor": {
    "name": "heart",
    "set": "major",
    "description": "Used to represent a heart or an action to love or like something.",
    "keywords": [
      "heart",
      "love"
    ]
  },
  "HideKeyboardMajor": {
    "name": "hide keyboard",
    "set": "major",
    "description": "Used to represent an action to hide the keyboard on a mobile device.",
    "keywords": [
      "hide keyboard",
      "keyboard"
    ]
  },
  "HideMinor": {
    "name": "hide",
    "set": "minor",
    "description": "Used to represent an action to hide something, or to represent a hidden item or resource.",
    "keywords": [
      "section",
      "conceal",
      "eye",
      "see",
      "show"
    ]
  },
  "HintMajor": {
    "name": "hint",
    "set": "major",
    "description": "Used to represent a hint or idea.",
    "keywords": [
      "hint",
      "idea",
      "light bulb"
    ]
  },
  "HomeMajor": {
    "name": "home",
    "set": "major",
    "description": "Used to help direct merchants back to the admin home page.",
    "keywords": [
      "home page",
      "home",
      "base",
      "main page",
      "start"
    ]
  },
  "HomeMinor": {
    "name": "home",
    "set": "minor",
    "description": "Used to help direct merchants back to the admin home page.",
    "keywords": [
      "home page",
      "home",
      "base",
      "main page",
      "start"
    ]
  },
  "HorizontalDotsMinor": {
    "name": "horizontal dots",
    "set": "minor",
    "description": "Used to represent additional actions in areas where three or more actions are used.",
    "keywords": [
      "menu",
      "ellipsis",
      "three dots",
      "dots",
      "overflow"
    ]
  },
  "IconsMajor": {
    "name": "icons",
    "set": "major",
    "description": "Used to represent icons or shapes.",
    "keywords": [
      "icons",
      "shapes"
    ]
  },
  "IllustrationMajor": {
    "name": "illustration",
    "set": "major",
    "description": "Used to represent an illustration, painting or brush.",
    "keywords": [
      "brush",
      "illustration",
      "paint"
    ]
  },
  "ImageAltMajor": {
    "name": "image alt",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ImageAltMinor": {
    "name": "image alt",
    "set": "minor",
    "description": "Used to represent the alt text attribute used to describe the appearance and function of an image on a page.",
    "keywords": [
      "accessibility",
      "alt text"
    ]
  },
  "ImageMajor": {
    "name": "image",
    "set": "major",
    "description": "Used to represent an image or placeholder.",
    "keywords": [
      "image",
      "placeholder"
    ]
  },
  "ImagesMajor": {
    "name": "images",
    "set": "major",
    "description": "Used to represent multiple images.",
    "keywords": [
      "images",
      "gallery"
    ]
  },
  "ImageWithTextMajor": {
    "name": "image with text",
    "set": "major",
    "description": "Used to represent a layout option of a single column, featuring an image and text.",
    "keywords": [
      "image",
      "picture",
      "photo",
      "text",
      "layout",
      "content",
      "section"
    ]
  },
  "ImageWithTextOverlayMajor": {
    "name": "image with text overlay",
    "set": "major",
    "description": "Used to represent a layout option of text overlaid on an image.",
    "keywords": [
      "image",
      "picture",
      "photo",
      "text",
      "content",
      "overlay",
      "layout",
      "section"
    ]
  },
  "ImportMinor": {
    "name": "import",
    "set": "minor",
    "description": "Used to denote the action of importing content.",
    "keywords": [
      "import",
      "external",
      "export",
      "bringin"
    ]
  },
  "ImportStoreMajor": {
    "name": "import store",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "IncomingMajor": {
    "name": "incoming",
    "set": "major",
    "description": "Used to represent an incoming item or resource, or importing an item or resource.",
    "keywords": [
      "import",
      "inbox",
      "incoming"
    ]
  },
  "InfoMinor": {
    "name": "info",
    "set": "minor",
    "description": "Used to represent a hint, or draw attention to a piece of information.",
    "keywords": [
      "info",
      "information",
      "hint"
    ]
  },
  "InstallMinor": {
    "name": "install",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "InventoryMajor": {
    "name": "inventory",
    "set": "major",
    "description": "Used to represent inventory or a warehouse.",
    "keywords": [
      "inventory",
      "warehouse"
    ]
  },
  "InviteMinor": {
    "name": "invite",
    "set": "minor",
    "description": "Used to represent an email or letter.",
    "keywords": [
      "email",
      "invite",
      "letter"
    ]
  },
  "IqMajor": {
    "name": "iq",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "JobsMajor": {
    "name": "jobs",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "KeyMajor": {
    "name": "key",
    "set": "major",
    "description": "Used to represent a key or security.",
    "keywords": [
      "key",
      "lock",
      "secure",
      "security",
      "unlock"
    ]
  },
  "LabelPrinterMajor": {
    "name": "label printer",
    "set": "major",
    "description": "Used to represent a label printer (a special printer that prints 4x6 shipping labels on thermal sticker paper).",
    "keywords": [
      "label",
      "printer",
      "4x6",
      "shipping",
      "print",
      "thermal"
    ]
  },
  "LandingPageMajor": {
    "name": "landing page",
    "set": "major",
    "description": "Used to represent a landing page or adding an item or resource to a page.",
    "keywords": [
      "landing",
      "landing page",
      "incoming"
    ]
  },
  "LanguageMinor": {
    "name": "language",
    "set": "minor",
    "description": "Used to represent internationalization or multiple language options.",
    "keywords": [
      "language",
      "international"
    ]
  },
  "LegalMajor": {
    "name": "legal",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "legal",
      "page",
      "scroll",
      "paper"
    ]
  },
  "LinkMinor": {
    "name": "link",
    "set": "minor",
    "description": "Used to represent a link.",
    "keywords": [
      "chain",
      "link"
    ]
  },
  "ListMajor": {
    "name": "list",
    "set": "major",
    "description": "Used to represent a list of items or resources, or a bulleted list.",
    "keywords": [
      "bulleted list",
      "list",
      "keywords",
      "todo"
    ]
  },
  "LiveViewMajor": {
    "name": "live view",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "LocationMajor": {
    "name": "location",
    "set": "major",
    "description": "Used to represent a location.",
    "keywords": [
      "location",
      "pin"
    ]
  },
  "LocationsMinor": {
    "name": "locations",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "LockMajor": {
    "name": "lock",
    "set": "major",
    "description": "Used to represent a lock, a secure item or resource or that an option or setting is currently locked.",
    "keywords": [
      "lock",
      "secure"
    ]
  },
  "LockMinor": {
    "name": "lock",
    "set": "minor",
    "description": "Used to represent a lock, a secure item or resource or that an option or setting is currently locked.",
    "keywords": [
      "lock",
      "secure"
    ]
  },
  "LogoBlockMajor": {
    "name": "logo block",
    "set": "major",
    "description": "Used to represent a layout option of one or more logos.",
    "keywords": [
      "logo",
      "list",
      "layout",
      "section",
      "circle",
      "dotted"
    ]
  },
  "LogOutMinor": {
    "name": "log out",
    "set": "minor",
    "description": "Used to denote the action of logging out of Shopify.",
    "keywords": [
      "logout",
      "log-out",
      "sign-out",
      "sign-off",
      "signoff",
      "disconnect",
      "exit",
      "quit"
    ]
  },
  "ManagedStoreMajor": {
    "name": "managed store",
    "set": "major",
    "description": "Used to represent a managed or approved store.",
    "keywords": [
      "approved",
      "managed",
      "store"
    ]
  },
  "MarketingMajor": {
    "name": "marketing",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketingMinor": {
    "name": "marketing",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketsMajor": {
    "name": "markets",
    "set": "major",
    "description": "Used to represent Markets, Shopify's international commerce product.",
    "keywords": [
      "markets",
      "international",
      "commerce",
      "global"
    ]
  },
  "MarkFulfilledMinor": {
    "name": "mark fulfilled",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarkPaidMinor": {
    "name": "mark paid",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MaximizeMajor": {
    "name": "maximize",
    "set": "major",
    "description": "Used to represent an action to make an item, resource or view larger.",
    "keywords": [
      "expand",
      "full screen",
      "maximise"
    ]
  },
  "MaximizeMinor": {
    "name": "maximize",
    "set": "minor",
    "description": "Used to represent an action to make an item, resource or view larger.",
    "keywords": [
      "expand",
      "full screen",
      "maximise"
    ]
  },
  "MentionMajor": {
    "name": "mention",
    "set": "major",
    "description": "Used to represent an action to mention someone.",
    "keywords": [
      "at",
      "mention"
    ]
  },
  "MergeMinor": {
    "name": "merge",
    "set": "minor",
    "description": "Used to represent merging of objects.",
    "keywords": [
      "merge",
      "combine",
      "union",
      "join"
    ]
  },
  "MicrophoneMajor": {
    "name": "microphone",
    "set": "major",
    "description": "Used to represent a microphone.",
    "keywords": [
      "mic",
      "microphone"
    ]
  },
  "MinimizeMajor": {
    "name": "minimize",
    "set": "major",
    "description": "Used to represent an action to make an item, resource or view smaller.",
    "keywords": [
      "minimise"
    ]
  },
  "MinimizeMinor": {
    "name": "minimize",
    "set": "minor",
    "description": "Used to represent an action to make an item, resource or view smaller.",
    "keywords": [
      "minimise"
    ]
  },
  "MinusMinor": {
    "name": "minus",
    "set": "minor",
    "description": "Used to denote the action of removing an item.",
    "keywords": [
      "minus",
      "negative",
      "subtract",
      "subtraction",
      "math",
      "-",
      "substract",
      "less"
    ]
  },
  "MobileAcceptMajor": {
    "name": "mobile accept",
    "set": "major",
    "description": "Used to represent a confirm action. Most commonly used in the toolbar in an _edit_ context.",
    "keywords": [
      "accept",
      "save",
      "confirm",
      "check"
    ]
  },
  "MobileBackArrowMajor": {
    "name": "mobile back arrow",
    "set": "major",
    "description": "Used to represent backwards navigation.",
    "keywords": [
      "back",
      "navigation"
    ]
  },
  "MobileCancelMajor": {
    "name": "mobile cancel",
    "set": "major",
    "description": "Used to denote the action of cancelling a task or action and to close an overlay modal or bottom sheet.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "undo",
      "x",
      "close"
    ]
  },
  "MobileChevronMajor": {
    "name": "mobile chevron",
    "set": "major",
    "description": "Used to represent the back action commonly found in iOS.",
    "keywords": [
      "back",
      "ios",
      "navigation"
    ]
  },
  "MobileHamburgerMajor": {
    "name": "mobile hamburger",
    "set": "major",
    "description": "Used to help direct merchants to navigation on mobile.",
    "keywords": [
      "hamburger",
      "menu",
      "burger"
    ]
  },
  "MobileHorizontalDotsMajor": {
    "name": "mobile horizontal dots",
    "set": "major",
    "description": "Used to represent an action to reveal a menu or more options.",
    "keywords": [
      "dots",
      "ellipsis",
      "menu",
      "options",
      "overflow",
      "..."
    ]
  },
  "MobileMajor": {
    "name": "mobile",
    "set": "major",
    "description": "Used to represent a mobile phone.",
    "keywords": [
      "mobile",
      "phone"
    ]
  },
  "MobilePlusMajor": {
    "name": "mobile plus",
    "set": "major",
    "description": "Used to represent an action to add an item or resource, or increase the quantity of an item or resource.",
    "keywords": [
      "add",
      "plus",
      "increase"
    ]
  },
  "MobileVerticalDotsMajor": {
    "name": "mobile vertical dots",
    "set": "major",
    "description": "Used to represent an action to reveal a menu or more options.",
    "keywords": [
      "dots",
      "menu",
      "options",
      "overflow"
    ]
  },
  "MonerisMajor": {
    "name": "moneris",
    "set": "major",
    "description": "Used to represent a handheld credit card reader.",
    "keywords": [
      "credit card",
      "moneris",
      "payment"
    ]
  },
  "NatureMajor": {
    "name": "nature",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "NavigationMajor": {
    "name": "navigation",
    "set": "major",
    "description": "Used to represent a compass or navigation.",
    "keywords": [
      "compass",
      "navigation"
    ]
  },
  "NoteMajor": {
    "name": "note",
    "set": "major",
    "description": "Used to represent a document or note.",
    "keywords": [
      "annotations",
      "document",
      "note",
      "notes",
      "page",
      "paper",
      "tags"
    ]
  },
  "NoteMinor": {
    "name": "note",
    "set": "minor",
    "description": "Used to represent a document or note.",
    "keywords": [
      "annotations",
      "document",
      "note",
      "notes",
      "page",
      "paper",
      "tags"
    ]
  },
  "NotificationMajor": {
    "name": "notification",
    "set": "major",
    "description": "Used to represent a notification or alert.",
    "keywords": [
      "notifications",
      "alerts",
      "bell"
    ]
  },
  "OnlineStoreMajor": {
    "name": "online store",
    "set": "major",
    "description": "Used to represent an online store.",
    "keywords": [
      "online store",
      "store"
    ]
  },
  "OnlineStoreMinor": {
    "name": "online store",
    "set": "minor",
    "description": "Used to represent an online store.",
    "keywords": [
      "online store",
      "store"
    ]
  },
  "OrdersMajor": {
    "name": "orders",
    "set": "major",
    "description": "Used to represent an inbox or an item or resource arriving in an inbox.",
    "keywords": [
      "inbox",
      "orders"
    ]
  },
  "OrdersMinor": {
    "name": "orders",
    "set": "minor",
    "description": "Used to represent an inbox or an item or resource arriving in an inbox.",
    "keywords": [
      "inbox",
      "orders"
    ]
  },
  "OrderStatusMinor": {
    "name": "order status",
    "set": "minor",
    "description": "Used to represent the activity of an inbox.",
    "keywords": [
      "activity",
      "inbox",
      "status",
      "orders"
    ]
  },
  "OutgoingMajor": {
    "name": "outgoing",
    "set": "major",
    "description": "Used to represent an outgoing item or resource, or exporting an item or resource.",
    "keywords": [
      "export",
      "outbox",
      "outgoing"
    ]
  },
  "PackageMajor": {
    "name": "package",
    "set": "major",
    "description": "Used to represent a package or box that merchants can ship their products in.",
    "keywords": [
      "shipping",
      "box",
      "package",
      "cardboard"
    ]
  },
  "PageDownMajor": {
    "name": "page down",
    "set": "major",
    "description": "Used to represent an action to download a page or document.",
    "keywords": [
      "document",
      "download",
      "page",
      "paper"
    ]
  },
  "PageMajor": {
    "name": "page",
    "set": "major",
    "description": "Used to represent a blank page or document.",
    "keywords": [
      "blank",
      "document",
      "page",
      "paper"
    ]
  },
  "PageMinusMajor": {
    "name": "page minus",
    "set": "major",
    "description": "Used to represent an action to remove a page or document.",
    "keywords": [
      "document",
      "minus",
      "page",
      "paper",
      "remove"
    ]
  },
  "PagePlusMajor": {
    "name": "page plus",
    "set": "major",
    "description": "Used to represent an action to add a page or document.",
    "keywords": [
      "add",
      "document",
      "page",
      "paper"
    ]
  },
  "PageUpMajor": {
    "name": "page up",
    "set": "major",
    "description": "Used to represent an action to upload a page or document.",
    "keywords": [
      "document",
      "page",
      "paper",
      "upload"
    ]
  },
  "PaginationEndMinor": {
    "name": "pagination end",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaginationStartMinor": {
    "name": "pagination start",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaintBrushMajor": {
    "name": "paint brush",
    "set": "major",
    "description": "Used to represent a paintbrush or an action to customize an item or resource.",
    "keywords": [
      "brush",
      "customize",
      "paintbrush"
    ]
  },
  "PauseCircleMajor": {
    "name": "pause circle",
    "set": "major",
    "description": "Used to represent an action to pause something.",
    "keywords": [
      "pause",
      "media",
      "video",
      "motion",
      "animation",
      "film"
    ]
  },
  "PauseMajor": {
    "name": "pause",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PauseMinor": {
    "name": "pause",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaymentsMajor": {
    "name": "payments",
    "set": "major",
    "description": "Used to represent a payment made by credit or debit card.",
    "keywords": [
      "credit",
      "credit card",
      "debit",
      "debit card",
      "payment"
    ]
  },
  "PhoneInMajor": {
    "name": "phone in",
    "set": "major",
    "description": "Used to represent an incoming phone call.",
    "keywords": [
      "call",
      "incoming",
      "phone"
    ]
  },
  "PhoneMajor": {
    "name": "phone",
    "set": "major",
    "description": "Used to represent a phone or phone call.",
    "keywords": [
      "call",
      "phone"
    ]
  },
  "PhoneOutMajor": {
    "name": "phone out",
    "set": "major",
    "description": "Used to represent an outgoing phone call.",
    "keywords": [
      "call",
      "outgoing",
      "phone"
    ]
  },
  "PinMajor": {
    "name": "pin",
    "set": "major",
    "description": "Used to represent a pin or an action to pin or save something.",
    "keywords": [
      "pin",
      "save"
    ]
  },
  "PinMinor": {
    "name": "pin",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PlayCircleMajor": {
    "name": "play circle",
    "set": "major",
    "description": "Used to represent an action to play or resume something.",
    "keywords": [
      "video",
      "control",
      "media",
      "play",
      "motion",
      "animation",
      "film",
      "circle"
    ]
  },
  "PlayMajor": {
    "name": "play",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PlayMinor": {
    "name": "play",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PlusMinor": {
    "name": "plus",
    "set": "minor",
    "description": "Used to denote the action of adding an item and zooming into a map.",
    "keywords": [
      "plus",
      "addition",
      "add",
      "math"
    ]
  },
  "PointOfSaleMajor": {
    "name": "point of sale",
    "set": "major",
    "description": "Used to represent a point of sale or sales register.",
    "keywords": [
      "point of sale",
      "POS",
      "terminal",
      "register"
    ]
  },
  "PopularMajor": {
    "name": "popular",
    "set": "major",
    "description": "Used to represent activity or something increasing in popularity.",
    "keywords": [
      "activity",
      "graph",
      "popular"
    ]
  },
  "PriceLookupMinor": {
    "name": "price lookup",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PrintMajor": {
    "name": "print",
    "set": "major",
    "description": "Used to represent a printer or an action to print something.",
    "keywords": [
      "desktop",
      "label",
      "printer"
    ]
  },
  "PrintMinor": {
    "name": "print",
    "set": "minor",
    "description": "Used to denote the action of printing.",
    "keywords": [
      "print",
      "printing",
      "printer"
    ]
  },
  "ProductReturnsMinor": {
    "name": "product returns",
    "set": "minor",
    "description": "Used to help direct merchants to returns page.",
    "keywords": [
      "return",
      "product return",
      "return page",
      "arrow"
    ]
  },
  "ProductsMajor": {
    "name": "products",
    "set": "major",
    "description": "Used to represent products or a price tag.",
    "keywords": [
      "tag",
      "products",
      "price"
    ]
  },
  "ProductsMinor": {
    "name": "products",
    "set": "minor",
    "description": "Used to represent products or a price tag.",
    "keywords": [
      "tag",
      "products",
      "price"
    ]
  },
  "ProfileMajor": {
    "name": "profile",
    "set": "major",
    "description": "Used to represent a staff member.",
    "keywords": [
      "avatar",
      "user",
      "profile",
      "me",
      "portrait",
      "staff"
    ]
  },
  "ProfileMinor": {
    "name": "profile",
    "set": "minor",
    "description": "Used to represent a staff member.",
    "keywords": [
      "avatar",
      "user",
      "profile",
      "me",
      "portrait",
      "staff"
    ]
  },
  "PromoteMinor": {
    "name": "promote",
    "set": "minor",
    "description": "Used to represent an action to open an external resource, or promote an item or resource.",
    "keywords": [
      "external",
      "promote"
    ]
  },
  "QuestionMarkInverseMajor": {
    "name": "question mark inverse",
    "set": "major",
    "description": "Used to give merchants help or support for a feature.",
    "keywords": [
      "question",
      "question mark",
      "help",
      "support",
      "learn more",
      "circle"
    ]
  },
  "QuestionMarkInverseMinor": {
    "name": "question mark inverse",
    "set": "minor",
    "description": "Used to give merchants help or support for a feature.",
    "keywords": [
      "question",
      "question mark",
      "help",
      "support",
      "learn more",
      "circle"
    ]
  },
  "QuestionMarkMajor": {
    "name": "question mark",
    "set": "major",
    "description": "Used to give merchants help or support for a feature.",
    "keywords": [
      "question",
      "question mark",
      "help",
      "support",
      "learn more",
      "circle"
    ]
  },
  "QuestionMarkMinor": {
    "name": "question mark",
    "set": "minor",
    "description": "Used to represent help, information or as an action to reveal more information about an item or resource.",
    "keywords": [
      "help",
      "hint",
      "info",
      "question"
    ]
  },
  "QuickSaleMajor": {
    "name": "quick sale",
    "set": "major",
    "description": "Used to represent a quick checkout process or quick sale.",
    "keywords": [
      "cart",
      "checkout",
      "quick",
      "sale"
    ]
  },
  "ReadTimeMinor": {
    "name": "read time",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReceiptMajor": {
    "name": "receipt",
    "set": "major",
    "description": "Used to represent a sales receipt or invoice.",
    "keywords": [
      "invoice",
      "receipt",
      "sale"
    ]
  },
  "RecentSearchesMajor": {
    "name": "recent searches",
    "set": "major",
    "description": "Used to represent recent searches or search history.",
    "keywords": [
      "history",
      "recent",
      "recent search",
      "search history"
    ]
  },
  "RedoMajor": {
    "name": "redo",
    "set": "major",
    "description": "Used to indicate redoing an action after undoing it.",
    "keywords": [
      "redo",
      "undo",
      "rollback",
      "return"
    ]
  },
  "ReferralCodeMajor": {
    "name": "referral code",
    "set": "major",
    "description": "Used to represent a referral code’s usage status.",
    "keywords": [
      "referral",
      "code",
      "coupon"
    ]
  },
  "ReferralMajor": {
    "name": "referral",
    "set": "major",
    "description": "Used to represent the source of a referral.",
    "keywords": [
      "referral",
      "code",
      "coupon"
    ]
  },
  "RefreshMajor": {
    "name": "refresh",
    "set": "major",
    "description": "Used to represent an action to refresh or sync an item or resource.",
    "keywords": [
      "refresh",
      "reload",
      "sync"
    ]
  },
  "RefreshMinor": {
    "name": "refresh",
    "set": "minor",
    "description": "Used to denote the action of resetting a customer’s account password on their customer page.",
    "keywords": [
      "refresh",
      "reload",
      "sync"
    ]
  },
  "RefundMajor": {
    "name": "refund",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "RefundMinor": {
    "name": "refund",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "RemoveProductMajor": {
    "name": "remove product",
    "set": "major",
    "description": "Used to represent an action to remove a product.",
    "keywords": [
      "remove",
      "minus",
      "product"
    ]
  },
  "RepeatOrderMajor": {
    "name": "repeat order",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReplaceMajor": {
    "name": "replace",
    "set": "major",
    "description": "Used to represent an action to replace an item or resource with another.",
    "keywords": [
      "replace",
      "image",
      "picture",
      "photo",
      "switch",
      "swap",
      "arrow",
      "arrows",
      "square"
    ]
  },
  "ReplayMinor": {
    "name": "replay",
    "set": "minor",
    "description": "Used to represent an action to replay or restart something.",
    "keywords": [
      "replay",
      "restart"
    ]
  },
  "ReportMinor": {
    "name": "report",
    "set": "minor",
    "description": "Used to represent analytics or a report.",
    "keywords": [
      "analytics",
      "report",
      "reporting"
    ]
  },
  "ReportsMajor": {
    "name": "reports",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ResetMinor": {
    "name": "reset",
    "set": "minor",
    "description": "Used to represent an action to reset or restart something.",
    "keywords": [
      "reset",
      "restart"
    ]
  },
  "ResourcesMajor": {
    "name": "resources",
    "set": "major",
    "description": "Used to represent resources to learn more about a topic or feature.",
    "keywords": [
      "resources",
      "learn more",
      "glasses",
      "research"
    ]
  },
  "ReturnMinor": {
    "name": "return",
    "set": "minor",
    "description": "Used to represent an action to create a new line, sometimes referred to as a carriage return.",
    "keywords": [
      "enter",
      "return"
    ]
  },
  "RiskMajor": {
    "name": "risk",
    "set": "major",
    "description": "Used to represent elevated risk on a payment or order, usually the risk of credit card fraud.",
    "keywords": [
      "risk",
      "fraud"
    ]
  },
  "RiskMinor": {
    "name": "risk",
    "set": "minor",
    "description": "Used to represent risk associated with orders.",
    "keywords": [
      "risk",
      "warning",
      "triangle",
      "alert"
    ]
  },
  "SandboxMajor": {
    "name": "sandbox",
    "set": "major",
    "description": "Used to represent a development store (feature exclusive to Shopify Plus Partners).",
    "keywords": [
      "sandbox",
      "plus",
      "partners",
      "partner",
      "development",
      "testing"
    ]
  },
  "SaveMinor": {
    "name": "save",
    "set": "minor",
    "description": "Used to denote the action of saving.",
    "keywords": [
      "save",
      "saving",
      "store"
    ]
  },
  "SearchMajor": {
    "name": "search",
    "set": "major",
    "description": "Used to represent search or an action to search for an item or resource.",
    "keywords": [
      "find",
      "look up",
      "magnifying glass",
      "search"
    ]
  },
  "SearchMinor": {
    "name": "search",
    "set": "minor",
    "description": "Used to denote the action of searching throughout the admin.",
    "keywords": [
      "search",
      "find",
      "glass"
    ]
  },
  "SectionMajor": {
    "name": "section",
    "set": "major",
    "description": "Used to represent the middle section of a component, page or layout.",
    "keywords": [
      "layout",
      "middle",
      "content",
      "dashed",
      "section"
    ]
  },
  "SecureMajor": {
    "name": "secure",
    "set": "major",
    "description": "Used to represent a secure or protected item or resource, or than an item or resource can be trusted.",
    "keywords": [
      "protected",
      "secure",
      "trust",
      "verified"
    ]
  },
  "SelectMinor": {
    "name": "select",
    "set": "minor",
    "description": "Used to denote the action opening a select.",
    "keywords": [
      "caret",
      "arrow",
      "up",
      "down",
      "select",
      "open"
    ]
  },
  "SendMajor": {
    "name": "send",
    "set": "major",
    "description": "Used to represent an action to send a message, commonly used in a chat UI.",
    "keywords": [
      "send",
      "mail",
      "plane",
      "message",
      "chat"
    ]
  },
  "SettingsMajor": {
    "name": "settings",
    "set": "major",
    "description": "Used to represent settings or a configuration option.",
    "keywords": [
      "configure",
      "settings",
      "cog"
    ]
  },
  "SettingsMinor": {
    "name": "settings",
    "set": "minor",
    "description": "Used to represent settings or a configuration option.",
    "keywords": [
      "configure",
      "settings",
      "cog"
    ]
  },
  "ShareIosMinor": {
    "name": "share ios",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ShareMinor": {
    "name": "share",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ShipmentMajor": {
    "name": "shipment",
    "set": "major",
    "description": "Used to represent shipping-related events or actions such as shipping labels or tracking information.",
    "keywords": [
      "shipping",
      "shipment",
      "carrier",
      "ship",
      "fulfillment",
      "fulfilment",
      "label",
      "tracking",
      "truck"
    ]
  },
  "ShopcodesMajor": {
    "name": "shopcodes",
    "set": "major",
    "description": "Used to represent a QR code.",
    "keywords": [
      "qr code"
    ]
  },
  "SidebarLeftMajor": {
    "name": "sidebar left",
    "set": "major",
    "description": "Used to represent the left section of a component, page or layout.",
    "keywords": [
      "sidebar",
      "layout",
      "section",
      "left",
      "content"
    ]
  },
  "SidebarRightMajor": {
    "name": "sidebar right",
    "set": "major",
    "description": "Used to represent the right section of a component, page or layout.",
    "keywords": [
      "sidebar",
      "layout",
      "section",
      "right",
      "content"
    ]
  },
  "SlideshowMajor": {
    "name": "slideshow",
    "set": "major",
    "description": "Used to represent a slideshow or series of images.",
    "keywords": [
      "slides",
      "slideshow",
      "image",
      "photo",
      "picture",
      "thumbnail",
      "dots",
      "swipe"
    ]
  },
  "SmileyHappyMajor": {
    "name": "smiley happy",
    "set": "major",
    "description": "Used to represent a happy customer or user, a smiling face or a smiley emoji.",
    "keywords": [
      "smiley",
      "happy",
      "emoji"
    ]
  },
  "SmileyJoyMajor": {
    "name": "smiley joy",
    "set": "major",
    "description": "Used to represent a very happy customer or user, a smiling face or a smiley emoji.",
    "keywords": [
      "smiley",
      "happy",
      "ecstatic",
      "emoji"
    ]
  },
  "SmileyNeutralMajor": {
    "name": "smiley neutral",
    "set": "major",
    "description": "Used to represent a neutral customer or user, a neutral face or a neutral emoji.",
    "keywords": [
      "neutral",
      "emoji"
    ]
  },
  "SmileySadMajor": {
    "name": "smiley sad",
    "set": "major",
    "description": "Used to represent a sad customer or user, a sad face or a sad emoji.",
    "keywords": [
      "sad",
      "emoji"
    ]
  },
  "SocialAdMajor": {
    "name": "social ad",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SocialPostMajor": {
    "name": "social post",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SoftPackMajor": {
    "name": "soft pack",
    "set": "major",
    "description": "Used to represent a soft pack envelope (or bubble mailer) that merchants can use to ship orders to their customers.",
    "keywords": [
      "shipping",
      "packaging",
      "envelope",
      "bubble",
      "mailer",
      "bubblewrap",
      "padded"
    ]
  },
  "SortAscendingMajor": {
    "name": "sort ascending",
    "set": "major",
    "description": "Used to indicate that a list of items or resources has been sorted by ascending order.",
    "keywords": [
      "ascending",
      "sort",
      "order"
    ]
  },
  "SortDescendingMajor": {
    "name": "sort descending",
    "set": "major",
    "description": "Used to indicate that a list of items or resources has been sorted by descending order.",
    "keywords": [
      "descending",
      "sort",
      "order"
    ]
  },
  "SortMinor": {
    "name": "sort",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SoundMajor": {
    "name": "sound",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "StarFilledMinor": {
    "name": "star filled",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "star",
      "starred",
      "favourite",
      "favorite"
    ]
  },
  "StarOutlineMinor": {
    "name": "star outline",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "favorite",
      "favourite",
      "starred",
      "star"
    ]
  },
  "StoreMajor": {
    "name": "store",
    "set": "major",
    "description": "Used to represent a store or shop.",
    "keywords": [
      "store",
      "shop"
    ]
  },
  "StoreMinor": {
    "name": "store",
    "set": "minor",
    "description": "Used to represent a store or shop.",
    "keywords": [
      "store",
      "shop"
    ]
  },
  "StoreStatusMajor": {
    "name": "store status",
    "set": "major",
    "description": "Used to represent the activity of a shop or store.",
    "keywords": [
      "status",
      "activity"
    ]
  },
  "TabletMajor": {
    "name": "tablet",
    "set": "major",
    "description": "Used to represent a tablet.",
    "keywords": [
      "tablet",
      "ipad"
    ]
  },
  "TapChipMajor": {
    "name": "tap chip",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TaxMajor": {
    "name": "tax",
    "set": "major",
    "description": "Used to represent sales tax or a tax receipt.",
    "keywords": [
      "sales tax",
      "tax reciept",
      "tax"
    ]
  },
  "TeamMajor": {
    "name": "team",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "connect",
      "connected",
      "path",
      "team",
      "related"
    ]
  },
  "TemplateMajor": {
    "name": "template",
    "set": "major",
    "description": "Used to represent a Shopify Theme Template.",
    "keywords": [
      "template",
      "theme",
      "section",
      "editor",
      "online store"
    ]
  },
  "TextAlignmentCenterMajor": {
    "name": "text alignment center",
    "set": "major",
    "description": "Icon indicating alignment of text at the center",
    "keywords": [
      "align",
      "alignment",
      "center",
      "rte",
      "text"
    ]
  },
  "TextAlignmentLeftMajor": {
    "name": "text alignment left",
    "set": "major",
    "description": "Icon indicating alignment of text on the left side",
    "keywords": [
      "align",
      "alignment",
      "left",
      "rte",
      "text"
    ]
  },
  "TextAlignmentRightMajor": {
    "name": "text alignment right",
    "set": "major",
    "description": "Icon indicating alignment of text on the right side",
    "keywords": [
      "align",
      "alignment",
      "right",
      "rte",
      "text"
    ]
  },
  "TextBlockMajor": {
    "name": "text block",
    "set": "major",
    "description": "Used to represent a paragraph or block of text.",
    "keywords": [
      "text",
      "paragraph"
    ]
  },
  "TextMajor": {
    "name": "text",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ThemeEditMajor": {
    "name": "theme edit",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ThemesMajor": {
    "name": "themes",
    "set": "major",
    "description": "Used to indicate free themes in the Shopify theme store.",
    "keywords": [
      "theme",
      "free",
      "customize"
    ]
  },
  "ThemeStoreMajor": {
    "name": "theme store",
    "set": "major",
    "description": "Used to represent the Shopify theme store.",
    "keywords": [
      "theme",
      "store",
      "shop",
      "customize"
    ]
  },
  "ThumbsDownMajor": {
    "name": "thumbs down",
    "set": "major",
    "description": "Used to represent an action to dislike or disapprove of something.",
    "keywords": [
      "down",
      "thumbs down",
      "no",
      "downvote",
      "dislike",
      "negative",
      "social",
      "dislike"
    ]
  },
  "ThumbsDownMinor": {
    "name": "thumbs down",
    "set": "minor",
    "description": "Used to represent an action to dislike or disapprove of something.",
    "keywords": [
      "down",
      "thumbs down",
      "no",
      "downvote",
      "dislike",
      "disapprove",
      "negative",
      "social"
    ]
  },
  "ThumbsUpMajor": {
    "name": "thumbs up",
    "set": "major",
    "description": "Used to represent an action to like or approve of something.",
    "keywords": [
      "social",
      "thumbs up",
      "hand",
      "like",
      "approve",
      "positive",
      "yes",
      "upvote"
    ]
  },
  "ThumbsUpMinor": {
    "name": "thumbs up",
    "set": "minor",
    "description": "Used to represent an action to like or approve of something.",
    "keywords": [
      "social",
      "thumbs up",
      "hand",
      "like",
      "approve",
      "positive",
      "yes",
      "upvote"
    ]
  },
  "TickMinor": {
    "name": "tick",
    "set": "minor",
    "description": "N/A",
    "keywords": [
      "checkmark",
      "yes",
      "ok",
      "good",
      "tick"
    ]
  },
  "TickSmallMinor": {
    "name": "tick small",
    "set": "minor",
    "description": "Used to denote the action of checking a Polaris checkbox.",
    "keywords": [
      "checkmark",
      "yes",
      "ok",
      "good",
      "passed",
      "tick"
    ]
  },
  "TimelineAttachmentMajor": {
    "name": "timeline attachment",
    "set": "major",
    "description": "This icon denotes an attachment of any file to a timeline.",
    "keywords": [
      "timeline",
      "attachment",
      "generic",
      "file"
    ]
  },
  "TipsMajor": {
    "name": "tips",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TitleMinor": {
    "name": "title",
    "set": "minor",
    "description": "Used to represent a title or heading block appearing as a sub-element of a section, page or layout.",
    "keywords": [
      "title",
      "heading",
      "subheading",
      "content",
      "block"
    ]
  },
  "ToolsMajor": {
    "name": "tools",
    "set": "major",
    "description": "Used to represent an action to customize an item or resource.",
    "keywords": [
      "tools",
      "options",
      "settings",
      "customize",
      "configure",
      "pen",
      "pencil",
      "ruler"
    ]
  },
  "TransactionFeeDollarMajor": {
    "name": "transaction fee (dollar)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeEuroMajor": {
    "name": "transaction fee (euro)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeePoundMajor": {
    "name": "transaction fee (pound)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeRupeeMajor": {
    "name": "transaction fee (rupee)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeYenMajor": {
    "name": "transaction fee (yen)",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionMajor": {
    "name": "transaction",
    "set": "major",
    "description": "Used to represent an action to customize an item or resource.",
    "keywords": [
      "tools",
      "options",
      "settings",
      "customize",
      "configure"
    ]
  },
  "TransferInMajor": {
    "name": "transfer in",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferMajor": {
    "name": "transfer",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferOutMajor": {
    "name": "transfer out",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferWithinShopifyMajor": {
    "name": "transfer within shopify",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransportMajor": {
    "name": "transport",
    "set": "major",
    "description": "Used as a navigation item in our emoji picker for the transport category.",
    "keywords": [
      "transport",
      "plane",
      "airplane",
      "emoji",
      "navigation"
    ]
  },
  "TroubleshootMajor": {
    "name": "troubleshoot",
    "set": "major",
    "description": "Used to represent an action to troubleshoot or view troubleshooting information.",
    "keywords": [
      "tools",
      "spanner",
      "wrench",
      "troubleshoot"
    ]
  },
  "TypeMajor": {
    "name": "type",
    "set": "major",
    "description": "Used to represent a typeface or an action to change the properties of a typeface or body of text.",
    "keywords": [
      "typography",
      "font",
      "typeface",
      "type",
      "letter",
      "text"
    ]
  },
  "UndoMajor": {
    "name": "undo",
    "set": "major",
    "description": "Used to indicate undoing an action in an editor context.",
    "keywords": [
      "redo",
      "undo",
      "return",
      "cancel"
    ]
  },
  "UnfulfilledMajor": {
    "name": "unfulfilled",
    "set": "major",
    "description": "Used to represent an empty inbox.",
    "keywords": [
      "inbox",
      "unfulilled"
    ]
  },
  "UnknownDeviceMajor": {
    "name": "unknown device",
    "set": "major",
    "description": "Used to represent an unknown device, item or resource.",
    "keywords": [
      "unknown",
      "device"
    ]
  },
  "UpdateInventoryMajor": {
    "name": "update inventory",
    "set": "major",
    "description": "Used to represent updated inventory at a warehouse.",
    "keywords": [
      "warehouse",
      "inventory",
      "manage",
      "update"
    ]
  },
  "UploadMajor": {
    "name": "upload",
    "set": "major",
    "description": "Used to represent the ability to upload a file",
    "keywords": [
      "upload",
      "file",
      "arrow",
      "up"
    ]
  },
  "VariantMajor": {
    "name": "variant",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ViewMajor": {
    "name": "view",
    "set": "major",
    "description": "Used to represent an action to view something, or to represent an openly viewable item or resource.",
    "keywords": [
      "view",
      "preview",
      "eye",
      "eyeball",
      "look",
      "see",
      "show",
      "reveal"
    ]
  },
  "ViewMinor": {
    "name": "view",
    "set": "minor",
    "description": "Used to denote the action of previewing an online store.",
    "keywords": [
      "view",
      "preview",
      "eye",
      "eyeball",
      "look",
      "see",
      "show",
      "reveal"
    ]
  },
  "ViewportNarrowMajor": {
    "name": "viewport narrow",
    "set": "major",
    "description": "Used to represent an action to make a viewport, item or resource narrower.",
    "keywords": [
      "viewport",
      "narrow",
      "arrows",
      "horizontal",
      "left",
      "right"
    ]
  },
  "ViewportWideMajor": {
    "name": "viewport wide",
    "set": "major",
    "description": "Used to represent an action to make a viewport, item or resource wider.",
    "keywords": [
      "viewport",
      "wide",
      "arrows",
      "horizontal",
      "left",
      "right"
    ]
  },
  "VocabularyMajor": {
    "name": "vocabulary",
    "set": "major",
    "description": "Used to represent a book, dictionary or thesaurus.",
    "keywords": [
      "book",
      "thesaurus",
      "dictionary"
    ]
  },
  "WandMajor": {
    "name": "wand",
    "set": "major",
    "description": "Used to represent an action to perform an automatic process or series of processes.",
    "keywords": [
      "magic",
      "wand",
      "automatic"
    ]
  },
  "WandMinor": {
    "name": "wand",
    "set": "minor",
    "description": "Used to represent an action to perform an automatic process or series of processes.",
    "keywords": [
      "magic",
      "wand",
      "automatic"
    ]
  },
  "WearableMajor": {
    "name": "wearable",
    "set": "major",
    "description": "Used to represent a wearable device or wristwatch.",
    "keywords": [
      "wearable",
      "watch",
      "wristwatch"
    ]
  },
  "WholesaleMajor": {
    "name": "wholesale",
    "set": "major",
    "description": "Used to represent a forklift or equipment used in a warehouse.",
    "keywords": [
      "forklift",
      "lift",
      "delivery",
      "warehouse"
    ]
  },
  "WifiMajor": {
    "name": "wifi",
    "set": "major",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  }
};

module.exports = metadata;
