import { useRef, useEffect } from 'react';

function useEventListener(event, handler, element = window, options) {
  const handlerRef = useRef(handler);
  const optionsRef = useRef(options);
  useEffect(() => {
    handlerRef.current = handler;
    optionsRef.current = options;
  }, [handler, options]);
  useEffect(() => {
    const handler = handlerRef.current;
    const options = optionsRef.current;
    element.addEventListener(event, handler, options);
    return () => element.removeEventListener(event, handler, options);
  }, [event, element]);
}

export { useEventListener };
