import React from 'react';
import { classNames } from '../../../../utilities/css.js';
import styles from '../../Grid.scss.js';

function Cell({
  area: gridArea,
  columnSpan,
  children
}) {
  const className = classNames(styles.Cell, (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.xs) && styles[`grid-${columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.xs}-column-xs`], (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.sm) && styles[`grid-${columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.sm}-column-sm`], (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.md) && styles[`grid-${columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.md}-column-md`], (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.lg) && styles[`grid-${columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.lg}-column-lg`], (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.xl) && styles[`grid-${columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.xl}-column-xl`]);
  return /*#__PURE__*/React.createElement("div", {
    className: className,
    style: {
      gridArea
    }
  }, children);
}

export { Cell };
