import React from 'react';
import './CustomProperties.scss.js';

const DEFAULT_COLOR_SCHEME = 'light';
function CustomProperties(props) {
  const {
    as: Component = 'div',
    children,
    className,
    colorScheme = DEFAULT_COLOR_SCHEME,
    style
  } = props;
  return /*#__PURE__*/React.createElement(Component, {
    "p-color-scheme": colorScheme,
    className: className,
    style: {
      color: 'var(--p-text)',
      ...style
    }
  }, children);
}

export { CustomProperties, DEFAULT_COLOR_SCHEME };
