'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');

function useEventListener(event, handler, element = window, options) {
  const handlerRef = React.useRef(handler);
  const optionsRef = React.useRef(options);
  React.useEffect(() => {
    handlerRef.current = handler;
    optionsRef.current = options;
  }, [handler, options]);
  React.useEffect(() => {
    const handler = handlerRef.current;
    const options = optionsRef.current;
    element.addEventListener(event, handler, options);
    return () => element.removeEventListener(event, handler, options);
  }, [event, element]);
}

exports.useEventListener = useEventListener;
