'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polarisTokens = require('@shopify/polaris-tokens');
var debounce = require('../../utilities/debounce.js');
var useEventListener = require('../../utilities/use-event-listener.js');
var Grid$1 = require('./Grid.scss.js');
var Cell = require('./components/Cell/Cell.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const {
  breakpoints
} = polarisTokens.tokens;

/** **Experimental!** This component is in alpha. Use with caution. */
const Grid = function Grid({
  gap,
  areas,
  children,
  columns
}) {
  const [gridTemplateAreas, setGridTemplateAreas] = React.useState(getAreas(areas));
  const style = {
    '--pc-grid-gap-xs': gap === null || gap === void 0 ? void 0 : gap.xs,
    '--pc-grid-gap-sm': gap === null || gap === void 0 ? void 0 : gap.sm,
    '--pc-grid-gap-md': gap === null || gap === void 0 ? void 0 : gap.md,
    '--pc-grid-gap-lg': gap === null || gap === void 0 ? void 0 : gap.lg,
    '--pc-grid-gap-xl': gap === null || gap === void 0 ? void 0 : gap.xl,
    '--pc-grid-columns-xs': columns === null || columns === void 0 ? void 0 : columns.xs,
    '--pc-grid-columns-sm': columns === null || columns === void 0 ? void 0 : columns.sm,
    '--pc-grid-columns-md': columns === null || columns === void 0 ? void 0 : columns.md,
    '--pc-grid-columns-lg': columns === null || columns === void 0 ? void 0 : columns.lg,
    '--pc-grid-columns-xl': columns === null || columns === void 0 ? void 0 : columns.xl,
    gridTemplateAreas
  };
  const handleResize = React.useMemo(() => debounce.debounce(() => setGridTemplateAreas(getAreas(areas)), 50), [areas]);
  useEventListener.useEventListener('resize', handleResize);
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: Grid$1["default"].Grid,
    style: style
  }, children);
};

function getAreas(areas) {
  if (areas === undefined) return;
  const xl = window.matchMedia(`(min-width: ${breakpoints['breakpoints-xl'].value})`).matches;
  const lg = window.matchMedia(`(min-width: ${breakpoints['breakpoints-lg'].value})`).matches;
  const md = window.matchMedia(`(min-width: ${breakpoints['breakpoints-md'].value})`).matches;
  const sm = window.matchMedia(`(min-width: ${breakpoints['breakpoints-sm'].value})`).matches;

  switch (true) {
    case xl:
      return formatAreas(areas.xl);

    case lg:
      return formatAreas(areas.lg);

    case md:
      return formatAreas(areas.md);

    case sm:
      return formatAreas(areas.sm);

    default:
      return formatAreas(areas.xs);
  }
}

function formatAreas(areas) {
  return `'${areas === null || areas === void 0 ? void 0 : areas.join(`' '`)}'`;
}
Grid.Cell = Cell.Cell;

exports.Grid = Grid;
exports.formatAreas = formatAreas;
