'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
require('./CustomProperties.scss.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const DEFAULT_COLOR_SCHEME = 'light';
function CustomProperties(props) {
  const {
    as: Component = 'div',
    children,
    className,
    colorScheme = DEFAULT_COLOR_SCHEME,
    style
  } = props;
  return /*#__PURE__*/React__default["default"].createElement(Component, {
    "p-color-scheme": colorScheme,
    className: className,
    style: {
      color: 'var(--p-text)',
      ...style
    }
  }, children);
}

exports.CustomProperties = CustomProperties;
exports.DEFAULT_COLOR_SCHEME = DEFAULT_COLOR_SCHEME;
