/**
 * Values to convert to CSS custom properties.
 * @example {background: '#000'} // --p-background: #000;
 */
export interface TokenProperties {
    description?: string;
    value: string;
}
export interface TokenGroup {
    [token: string]: TokenProperties;
}
export declare type ColorScheme = 'light' | 'dark';
/**
 * Mapping of Polaris color schemes to operating system color schemes.
 *
 * Note: The associated OS value will be set for the CSS `color-scheme` declaration.
 * https://developer.mozilla.org/en-US/docs/Web/CSS/color-scheme
 */
export declare type OSColorSchemes = {
    [C in ColorScheme]: 'light' | 'dark' | 'normal';
};
export declare const osColorSchemes: OSColorSchemes;
/**
 * Polaris color schemes and their associated color tokens.
 */
export declare type ColorSchemes = {
    [C in ColorScheme]: TokenGroup;
};
export interface Tokens {
    breakpoints: TokenGroup;
    colorSchemes: ColorSchemes;
    depth: TokenGroup;
    legacyTokens: TokenGroup;
    motion: TokenGroup;
    shape: TokenGroup;
    spacing: TokenGroup;
    typography: TokenGroup;
    zIndex: TokenGroup;
}
export declare const tokens: Tokens;
//# sourceMappingURL=tokens.d.ts.map