import { slicedToArray as _slicedToArray, objectSpread2 as _objectSpread2, objectWithoutProperties as _objectWithoutProperties, toConsumableArray as _toConsumableArray } from './_virtual/_rollupPluginBabelHelpers.mjs';

var _excluded = ["colorSchemes"];
var BASE_FONT_SIZE = 16;

function rem(value) {
  return value.replace( // https://regex101.com/r/RBL7EE/1
  /\d+(?:\.\d+|\d*)px/g, function (px) {
    return "".concat(parseInt(px, 10) / BASE_FONT_SIZE, "rem");
  });
}

function tokensToRems(tokenGroup) {
  return Object.fromEntries(Object.entries(tokenGroup).map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        token = _ref2[0],
        values = _ref2[1];

    return [token, _objectSpread2(_objectSpread2({}, values), {}, {
      value: rem(values.value)
    })];
  }));
}
function createVar(token) {
  return "--p-".concat(token);
}
/**
 * Allowed Polaris keyframes.
 *
 * Result: ['p-keyframes-fade-in', 'p-keyframes-spin', etc...]
 */

function getKeyframeNames(motionTokenGroup) {
  return Object.keys(motionTokenGroup).map(function (token) {
    return token.startsWith('keyframes') ? "p-".concat(token) : null;
  }).filter(Boolean);
}
/**
 * Allowed Polaris token custom properties.
 *
 * Result: ['--p-background', '--p-text', etc...]
 */

function getCustomPropertyNames(tokens) {
  var colorSchemes = tokens.colorSchemes,
      restTokenGroups = _objectWithoutProperties(tokens, _excluded);

  var customPropertyNames = [].concat(_toConsumableArray(Object.keys(colorSchemes.light).map(function (token) {
    return createVar(token);
  })), _toConsumableArray(Object.entries(restTokenGroups).map(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2);
        _ref4[0];
        var tokenGroup = _ref4[1];

    return Object.keys(tokenGroup).map(function (token) {
      return createVar(token);
    });
  }).flat()));
  return customPropertyNames;
}

export { createVar, getCustomPropertyNames, getKeyframeNames, tokensToRems };
