'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var _rollupPluginBabelHelpers = require('./_virtual/_rollupPluginBabelHelpers.js');

var _excluded = ["colorSchemes"];
var BASE_FONT_SIZE = 16;

function rem(value) {
  return value.replace( // https://regex101.com/r/RBL7EE/1
  /\d+(?:\.\d+|\d*)px/g, function (px) {
    return "".concat(parseInt(px, 10) / BASE_FONT_SIZE, "rem");
  });
}

function tokensToRems(tokenGroup) {
  return Object.fromEntries(Object.entries(tokenGroup).map(function (_ref) {
    var _ref2 = _rollupPluginBabelHelpers.slicedToArray(_ref, 2),
        token = _ref2[0],
        values = _ref2[1];

    return [token, _rollupPluginBabelHelpers.objectSpread2(_rollupPluginBabelHelpers.objectSpread2({}, values), {}, {
      value: rem(values.value)
    })];
  }));
}
function createVar(token) {
  return "--p-".concat(token);
}
/**
 * Allowed Polaris keyframes.
 *
 * Result: ['p-keyframes-fade-in', 'p-keyframes-spin', etc...]
 */

function getKeyframeNames(motionTokenGroup) {
  return Object.keys(motionTokenGroup).map(function (token) {
    return token.startsWith('keyframes') ? "p-".concat(token) : null;
  }).filter(Boolean);
}
/**
 * Allowed Polaris token custom properties.
 *
 * Result: ['--p-background', '--p-text', etc...]
 */

function getCustomPropertyNames(tokens) {
  var colorSchemes = tokens.colorSchemes,
      restTokenGroups = _rollupPluginBabelHelpers.objectWithoutProperties(tokens, _excluded);

  var customPropertyNames = [].concat(_rollupPluginBabelHelpers.toConsumableArray(Object.keys(colorSchemes.light).map(function (token) {
    return createVar(token);
  })), _rollupPluginBabelHelpers.toConsumableArray(Object.entries(restTokenGroups).map(function (_ref3) {
    var _ref4 = _rollupPluginBabelHelpers.slicedToArray(_ref3, 2);
        _ref4[0];
        var tokenGroup = _ref4[1];

    return Object.keys(tokenGroup).map(function (token) {
      return createVar(token);
    });
  }).flat()));
  return customPropertyNames;
}

exports.createVar = createVar;
exports.getCustomPropertyNames = getCustomPropertyNames;
exports.getKeyframeNames = getKeyframeNames;
exports.tokensToRems = tokensToRems;
